/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.MethodParameter;
import org.springframework.hateoas.server.MethodLinkBuilderFactory;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.hateoas.server.core.WebHandler;
import org.springframework.hateoas.server.mvc.UriComponentsBuilderFactory;
import org.springframework.hateoas.server.mvc.UriComponentsContributor;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class WebMvcLinkBuilderFactory
implements MethodLinkBuilderFactory<WebMvcLinkBuilder> {
    private List<UriComponentsContributor> uriComponentsContributors = new ArrayList<UriComponentsContributor>();

    public void setUriComponentsContributors(List<? extends UriComponentsContributor> uriComponentsContributors) {
        this.uriComponentsContributors = Collections.unmodifiableList(uriComponentsContributors);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller) {
        return WebMvcLinkBuilder.linkTo(controller);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        return WebMvcLinkBuilder.linkTo(controller, parameters);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller, Map<String, ?> parameters) {
        return WebMvcLinkBuilder.linkTo(controller, parameters);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Class<?> controller, Method method, Object ... parameters) {
        return WebMvcLinkBuilder.linkTo(controller, method, parameters);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Object invocationValue) {
        Function<String, UriComponentsBuilder> builderFactory = mapping -> UriComponentsBuilderFactory.getBuilder().path(mapping);
        return WebHandler.linkTo(invocationValue, WebMvcLinkBuilder::new, (builder, invocation) -> {
            MethodParameters parameters = new MethodParameters(invocation.getMethod());
            Iterator<Object> parameterValues = Arrays.asList(invocation.getArguments()).iterator();
            for (MethodParameter parameter : parameters.getParameters()) {
                Object parameterValue = parameterValues.next();
                this.uriComponentsContributors.stream().filter(it -> it.supportsParameter(parameter)).forEach(it -> it.enhance((UriComponentsBuilder)builder, parameter, parameterValue));
            }
            return builder;
        }).apply(builderFactory);
    }

    @Override
    public WebMvcLinkBuilder linkTo(Method method, Object ... parameters) {
        return WebMvcLinkBuilder.linkTo(method, parameters);
    }
}

