/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.util.Map;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.JsonPathLinkDiscoverer;
import org.springframework.http.MediaType;

public class HalLinkDiscoverer
extends JsonPathLinkDiscoverer {
    public HalLinkDiscoverer() {
        this(MediaTypes.HAL_JSON, MediaTypes.HAL_JSON_UTF8);
    }

    protected HalLinkDiscoverer(MediaType ... mediaTypes) {
        super("$._links..['%s']", mediaTypes);
    }

    @Override
    protected Link extractLink(Object element, LinkRelation rel) {
        if (!Map.class.isInstance(element)) {
            return super.extractLink(element, rel);
        }
        Map json = (Map)element;
        return new Link((String)json.get("href"), rel).withHreflang((String)json.get("hreflang")).withMedia((String)json.get("media")).withTitle((String)json.get("title")).withType((String)json.get("type")).withDeprecation((String)json.get("deprecation")).withProfile((String)json.get("profile")).withName((String)json.get("name"));
    }
}

