/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.web.util.UriTemplate;

class UriTemplateFactory {
    private static final Map<String, UriTemplate> CACHE = new ConcurrentReferenceHashMap();

    UriTemplateFactory() {
    }

    public static UriTemplate templateFor(String mapping) {
        Assert.hasText((String)mapping, (String)"Mapping must not be null or empty!");
        if (CACHE.containsKey(mapping)) {
            return CACHE.get(mapping);
        }
        UriTemplate template = new UriTemplate(mapping);
        CACHE.put(mapping, template);
        return template;
    }
}

