/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.hateoas.LinkDiscoverer;
import org.springframework.hateoas.LinkDiscoverers;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.config.ConverterRegisteringBeanPostProcessor;
import org.springframework.hateoas.config.ConverterRegisteringWebMvcConfigurer;
import org.springframework.hateoas.core.AnnotationRelProvider;
import org.springframework.hateoas.core.DefaultRelProvider;
import org.springframework.hateoas.core.DelegatingRelProvider;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.http.MediaType;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.plugin.core.config.EnablePluginRegistries;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.ClassUtils;

@Configuration
@EnablePluginRegistries(value={LinkDiscoverer.class})
class HateoasConfiguration {
    HateoasConfiguration() {
    }

    @Bean
    public MessageSourceAccessor linkRelationMessageSource() {
        try {
            ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
            messageSource.setBasename("classpath:rest-messages");
            return new MessageSourceAccessor((MessageSource)messageSource);
        }
        catch (Exception o_O) {
            throw new BeanCreationException("resourceDescriptionMessageSourceAccessor", "", (Throwable)o_O);
        }
    }

    @Bean
    ConverterRegisteringBeanPostProcessor jackson2ModuleRegisteringBeanPostProcessor(ObjectFactory<ConverterRegisteringWebMvcConfigurer> configurer) {
        return new ConverterRegisteringBeanPostProcessor(configurer);
    }

    @Bean
    RelProvider defaultRelProvider() {
        return ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null) ? new EvoInflectorRelProvider() : new DefaultRelProvider();
    }

    @Bean
    AnnotationRelProvider annotationRelProvider() {
        return new AnnotationRelProvider();
    }

    @Primary
    @Bean
    DelegatingRelProvider _relProvider(PluginRegistry<RelProvider, Class<?>> relProviderPluginRegistry) {
        return new DelegatingRelProvider(relProviderPluginRegistry);
    }

    @Bean
    PluginRegistryFactoryBean<RelProvider, Class<?>> relProviderPluginRegistry() {
        PluginRegistryFactoryBean factory = new PluginRegistryFactoryBean();
        factory.setType(RelProvider.class);
        factory.setExclusions(new Class[]{DelegatingRelProvider.class});
        return factory;
    }

    @Bean
    LinkDiscoverers linkDiscoverers(PluginRegistry<LinkDiscoverer, MediaType> linkDiscovererRegistry) {
        return new LinkDiscoverers(linkDiscovererRegistry);
    }
}

