/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;

class JacksonMappingProvider
implements MappingProvider {
    private final ObjectMapper objectMapper = new ObjectMapper();

    JacksonMappingProvider() {
    }

    public <T> @Nullable T map(@Nullable Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.convertValue(source, targetType);
        }
        catch (Exception exc) {
            throw new MappingException((Throwable)exc);
        }
    }

    public <T> @Nullable T map(@Nullable Object source, TypeRef<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        JavaType type = this.objectMapper.getTypeFactory().constructType(targetType.getType());
        try {
            return (T)this.objectMapper.convertValue(source, type);
        }
        catch (Exception exc) {
            throw new MappingException((Throwable)exc);
        }
    }
}

