/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.support.DefaultGraphQlRequest;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class DefaultGraphQlTester
implements GraphQlTester {
    private final GraphQlTransport transport;
    @Nullable
    private final java.util.function.Predicate<ResponseError> errorFilter;
    private final Configuration jsonPathConfig;
    private final DocumentSource documentSource;
    private final Duration responseTimeout;

    DefaultGraphQlTester(GraphQlTransport transport, @Nullable java.util.function.Predicate<ResponseError> errorFilter, Configuration jsonPathConfig, DocumentSource documentSource, Duration timeout) {
        Assert.notNull((Object)transport, (String)"GraphQlTransport is required");
        Assert.notNull((Object)jsonPathConfig, (String)"JSONPath Configuration is required");
        Assert.notNull((Object)documentSource, (String)"DocumentSource is required");
        this.transport = transport;
        this.errorFilter = errorFilter;
        this.jsonPathConfig = jsonPathConfig;
        this.documentSource = documentSource;
        this.responseTimeout = timeout;
    }

    @Override
    public GraphQlTester.Request<?> document(String document) {
        return new DefaultRequest(document);
    }

    @Override
    public GraphQlTester.Request<?> documentName(String documentName) {
        String document = (String)this.documentSource.getDocument(documentName).block(this.responseTimeout);
        Assert.notNull((Object)document, (String)"DocumentSource completed empty");
        return this.document(document);
    }

    @Override
    public GraphQlTester.Builder<?> mutate() {
        throw new UnsupportedOperationException();
    }

    private final class DefaultRequest
    implements GraphQlTester.Request<DefaultRequest> {
        private final String document;
        @Nullable
        private String operationName;
        private final Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private final Map<String, Object> extensions = new LinkedHashMap<String, Object>();

        private DefaultRequest(String document) {
            Assert.notNull((Object)document, (String)"`document` is required");
            this.document = document;
        }

        @Override
        public DefaultRequest operationName(@Nullable String name) {
            this.operationName = name;
            return this;
        }

        @Override
        public DefaultRequest variable(String name, @Nullable Object value) {
            this.variables.put(name, value);
            return this;
        }

        @Override
        public DefaultRequest extension(String name, @Nullable Object value) {
            this.extensions.put(name, value);
            return this;
        }

        @Override
        public GraphQlTester.Response execute() {
            return (GraphQlTester.Response)DefaultGraphQlTester.this.transport.execute(this.request()).map(response -> this.mapResponse((GraphQlResponse)response, this.request())).block(DefaultGraphQlTester.this.responseTimeout);
        }

        @Override
        public void executeAndVerify() {
            this.execute().path("$.errors").pathDoesNotExist();
        }

        @Override
        public GraphQlTester.Subscription executeSubscription() {
            return () -> DefaultGraphQlTester.this.transport.executeSubscription(this.request()).map(result -> this.mapResponse((GraphQlResponse)result, this.request()));
        }

        private GraphQlRequest request() {
            return new DefaultGraphQlRequest(this.document, this.operationName, this.variables, this.extensions);
        }

        private DefaultResponse mapResponse(GraphQlResponse response, GraphQlRequest request) {
            return new DefaultResponse(response, DefaultGraphQlTester.this.errorFilter, this.assertDecorator(request), DefaultGraphQlTester.this.jsonPathConfig);
        }

        private Consumer<Runnable> assertDecorator(GraphQlRequest request) {
            return assertion -> {
                try {
                    assertion.run();
                }
                catch (AssertionError ex) {
                    throw new AssertionError(((Throwable)((Object)ex)).getMessage() + "\nRequest: " + request, (Throwable)((Object)ex));
                }
            };
        }
    }

    private static final class DefaultPath
    implements GraphQlTester.Path {
        @Nullable
        private final String basePath;
        private final String path;
        private final ResponseDelegate delegate;
        private final JsonPath jsonPath;
        private final JsonPathExpectationsHelper pathHelper;

        private DefaultPath(@Nullable String basePath, String path, ResponseDelegate delegate) {
            Assert.notNull((Object)path, (String)"`path` is required");
            Assert.notNull((Object)delegate, (String)"ResponseContainer is required");
            this.basePath = basePath;
            this.path = path;
            this.delegate = delegate;
            String fullPath = DefaultPath.initDataJsonPath(this.path);
            this.jsonPath = JsonPath.compile((String)fullPath, (Predicate[])new Predicate[0]);
            this.pathHelper = new JsonPathExpectationsHelper(fullPath, new Object[0]);
        }

        private static String initDataJsonPath(String path) {
            if (!StringUtils.hasText((String)path)) {
                path = "$.data";
            } else if (!((String)path).startsWith("$") && !((String)path).startsWith("data.")) {
                path = "$.data." + (String)path;
            }
            return path;
        }

        @Override
        public GraphQlTester.Path path(String path) {
            return DefaultPath.forPath(this.basePath, path, this.delegate);
        }

        @Override
        public GraphQlTester.Path path(String path, Consumer<GraphQlTester.Path> pathConsumer) {
            return DefaultPath.forNestedPath(this.basePath, path, this.delegate, pathConsumer);
        }

        @Override
        public GraphQlTester.Path hasValue() {
            this.delegate.doAssert(() -> this.pathHelper.exists(this.delegate.jsonContent()));
            return this;
        }

        @Override
        public GraphQlTester.Path valueIsNull() {
            Assert.isTrue((boolean)this.jsonPath.isDefinite(), (String)"isNull applies only to JSONPath targeting a single value");
            this.delegate.doAssert(() -> {
                Object value = this.pathHelper.evaluateJsonPath(this.delegate.jsonContent());
                AssertionErrors.assertNull((String)("Expected null value at JSON path \"" + this.path + "\" but found " + value), (Object)value);
            });
            return this;
        }

        @Override
        public GraphQlTester.Path pathDoesNotExist() {
            this.delegate.doAssert(() -> this.pathHelper.doesNotHaveJsonPath(this.delegate.jsonContent()));
            return this;
        }

        @Override
        public <D> GraphQlTester.Entity<D, ?> entity(Class<D> entityType) {
            return new DefaultEntity(new TypeRefAdapter<D>(entityType));
        }

        @Override
        public <D> GraphQlTester.Entity<D, ?> entity(ParameterizedTypeReference<D> entityType) {
            return new DefaultEntity(new TypeRefAdapter<D>(entityType));
        }

        @Override
        public <D> GraphQlTester.EntityList<D> entityList(Class<D> elementType) {
            return new DefaultEntityList(new TypeRefAdapter(List.class, elementType));
        }

        @Override
        public <D> GraphQlTester.EntityList<D> entityList(ParameterizedTypeReference<D> elementType) {
            return new DefaultEntityList(new TypeRefAdapter(List.class, elementType));
        }

        @Override
        public GraphQlTester.Path matchesJson(String expectedJson) {
            this.matchesJson(expectedJson, false);
            return this;
        }

        @Override
        public GraphQlTester.Path matchesJsonStrictly(String expectedJson) {
            this.matchesJson(expectedJson, true);
            return this;
        }

        private void matchesJson(String expected, boolean strict) {
            this.delegate.doAssert(() -> {
                String actual = this.delegate.jsonContent(this.jsonPath);
                try {
                    new JsonExpectationsHelper().assertJsonEqual(expected, actual, strict);
                }
                catch (AssertionError ex) {
                    throw new AssertionError(((Throwable)((Object)ex)).getMessage() + "\n\nExpected JSON content:\n'" + expected + "'\n\nActual JSON content:\n'" + actual + "'\n\nInput path: '" + this.path + "'\n", (Throwable)((Object)ex));
                }
                catch (Exception ex) {
                    throw new AssertionError("JSON parsing error", ex);
                }
            });
        }

        static GraphQlTester.Path forPath(@Nullable String basePath, String path, ResponseDelegate delegate) {
            String pathToUse = DefaultPath.joinPaths(basePath, path);
            return new DefaultPath(basePath, pathToUse, delegate);
        }

        static GraphQlTester.Path forNestedPath(@Nullable String basePath, String path, ResponseDelegate delegate, Consumer<GraphQlTester.Path> consumer) {
            String pathToUse = DefaultPath.joinPaths(basePath, path);
            consumer.accept(new DefaultPath(pathToUse, pathToUse, delegate));
            return new DefaultPath(basePath, path, delegate);
        }

        private static String joinPaths(@Nullable String basePath, String path) {
            return basePath != null ? basePath + "." + path : path;
        }

        private class DefaultEntity<D, S extends GraphQlTester.Entity<D, S>>
        implements GraphQlTester.Entity<D, S> {
            private final D entity;

            protected DefaultEntity(TypeRefAdapter<D> typeAdapter) {
                this.entity = DefaultPath.this.delegate.read(DefaultPath.this.jsonPath, typeAdapter);
            }

            protected D getEntity() {
                return this.entity;
            }

            protected void doAssert(Runnable task) {
                DefaultPath.this.delegate.doAssert(task);
            }

            protected String getPath() {
                return DefaultPath.this.path;
            }

            @Override
            public GraphQlTester.Path path(String path) {
                return DefaultPath.forPath(DefaultPath.this.basePath, path, DefaultPath.this.delegate);
            }

            @Override
            public GraphQlTester.Path path(String path, Consumer<GraphQlTester.Path> pathConsumer) {
                return DefaultPath.forNestedPath(DefaultPath.this.basePath, path, DefaultPath.this.delegate, pathConsumer);
            }

            @Override
            public <T extends S> T isEqualTo(Object expected) {
                DefaultPath.this.delegate.doAssert(() -> AssertionErrors.assertEquals((String)DefaultPath.this.path, (Object)expected, this.entity));
                return this.self();
            }

            @Override
            public <T extends S> T isNotEqualTo(Object other) {
                DefaultPath.this.delegate.doAssert(() -> AssertionErrors.assertNotEquals((String)DefaultPath.this.path, (Object)other, this.entity));
                return this.self();
            }

            @Override
            public <T extends S> T isSameAs(Object expected) {
                DefaultPath.this.delegate.doAssert(() -> AssertionErrors.assertTrue((String)DefaultPath.this.path, (expected == this.entity ? 1 : 0) != 0));
                return this.self();
            }

            @Override
            public <T extends S> T isNotSameAs(Object other) {
                DefaultPath.this.delegate.doAssert(() -> AssertionErrors.assertTrue((String)DefaultPath.this.path, (other != this.entity ? 1 : 0) != 0));
                return this.self();
            }

            @Override
            public <T extends S> T matches(java.util.function.Predicate<D> predicate) {
                DefaultPath.this.delegate.doAssert(() -> AssertionErrors.assertTrue((String)DefaultPath.this.path, (boolean)predicate.test(this.entity)));
                return this.self();
            }

            @Override
            public <T extends S> T satisfies(Consumer<D> consumer) {
                DefaultPath.this.delegate.doAssert(() -> consumer.accept(this.entity));
                return this.self();
            }

            @Override
            public D get() {
                return this.entity;
            }

            private <T extends S> T self() {
                return (T)this;
            }
        }

        private static final class TypeRefAdapter<T>
        extends TypeRef<T> {
            private final Type type;

            TypeRefAdapter(Class<T> clazz) {
                this.type = clazz;
            }

            TypeRefAdapter(ParameterizedTypeReference<T> typeReference) {
                this.type = typeReference.getType();
            }

            TypeRefAdapter(Class<?> clazz, Class<?> generic) {
                this.type = ResolvableType.forClassWithGenerics(clazz, (Class[])new Class[]{generic}).getType();
            }

            TypeRefAdapter(Class<?> clazz, ParameterizedTypeReference<?> generic) {
                this.type = ResolvableType.forClassWithGenerics(clazz, (ResolvableType[])new ResolvableType[]{ResolvableType.forType(generic)}).getType();
            }

            public Type getType() {
                return this.type;
            }
        }

        private final class DefaultEntityList<E>
        extends DefaultEntity<List<E>, GraphQlTester.EntityList<E>>
        implements GraphQlTester.EntityList<E> {
            public DefaultEntityList(TypeRefAdapter<List<E>> typeAdapter) {
                super(typeAdapter);
            }

            @Override
            public GraphQlTester.EntityList<E> contains(E ... values) {
                this.doAssert(() -> {
                    List<Object> expected = Arrays.asList(values);
                    AssertionErrors.assertTrue((String)("Expecting list " + this.getEntity() + " at path '" + this.getPath() + "' to contain " + expected), (boolean)((List)this.getEntity()).containsAll(expected));
                });
                return this;
            }

            @Override
            public GraphQlTester.EntityList<E> doesNotContain(E ... values) {
                this.doAssert(() -> {
                    List<Object> expected = Arrays.asList(values);
                    AssertionErrors.assertTrue((String)("Expecting list " + this.getEntity() + " at path '" + this.getPath() + "' to not contain " + expected), (!((List)this.getEntity()).containsAll(expected) ? 1 : 0) != 0);
                });
                return this;
            }

            @Override
            public GraphQlTester.EntityList<E> containsExactly(E ... values) {
                this.doAssert(() -> {
                    List<Object> expected = Arrays.asList(values);
                    AssertionErrors.assertTrue((String)("Expecting list " + this.getEntity() + " at path '" + this.getPath() + "' to contain exactly " + expected), (boolean)((List)this.getEntity()).equals(expected));
                });
                return this;
            }

            @Override
            public GraphQlTester.EntityList<E> hasSize(int size) {
                this.doAssert(() -> AssertionErrors.assertTrue((String)("Expecting list " + this.getEntity() + " at path '" + this.getPath() + "' to have size == " + size), (((List)this.getEntity()).size() == size ? 1 : 0) != 0));
                return this;
            }

            @Override
            public GraphQlTester.EntityList<E> hasSizeLessThan(int size) {
                this.doAssert(() -> AssertionErrors.assertTrue((String)("Expecting list " + this.getEntity() + " at path '" + this.getPath() + "' to have size < " + size), (((List)this.getEntity()).size() < size ? 1 : 0) != 0));
                return this;
            }

            @Override
            public GraphQlTester.EntityList<E> hasSizeGreaterThan(int size) {
                this.doAssert(() -> AssertionErrors.assertTrue((String)("Expecting list " + this.getEntity() + " at path '" + this.getPath() + "' to have size > " + size), (((List)this.getEntity()).size() > size ? 1 : 0) != 0));
                return this;
            }
        }
    }

    private static final class DefaultResponse
    implements GraphQlTester.Response,
    GraphQlTester.Errors {
        private final ResponseDelegate delegate;

        private DefaultResponse(GraphQlResponse response, @Nullable java.util.function.Predicate<ResponseError> errorFilter, Consumer<Runnable> assertDecorator, Configuration jsonPathConfig) {
            this.delegate = new ResponseDelegate(response, errorFilter, assertDecorator, jsonPathConfig);
        }

        @Override
        public GraphQlTester.Path path(String path) {
            this.delegate.verifyErrors();
            return DefaultPath.forPath(null, path, this.delegate);
        }

        @Override
        public GraphQlTester.Path path(String path, Consumer<GraphQlTester.Path> pathConsumer) {
            return DefaultPath.forNestedPath(null, path, this.delegate, pathConsumer);
        }

        @Override
        public GraphQlTester.Errors errors() {
            return this;
        }

        @Override
        public GraphQlTester.Errors filter(java.util.function.Predicate<ResponseError> predicate) {
            this.delegate.filterErrors(predicate);
            return this;
        }

        @Override
        public GraphQlTester.Errors expect(java.util.function.Predicate<ResponseError> predicate) {
            this.delegate.expectErrors(predicate);
            return this;
        }

        @Override
        public GraphQlTester.Traversable verify() {
            this.delegate.verifyErrors();
            return this;
        }

        @Override
        public GraphQlTester.Traversable satisfy(Consumer<List<ResponseError>> consumer) {
            this.delegate.consumeErrors(consumer);
            return this;
        }
    }

    private static final class ResponseDelegate {
        private final DocumentContext jsonDoc;
        private final Supplier<String> jsonContent;
        private final List<ResponseError> errors;
        private final List<ResponseError> unexpectedErrors;
        private final Consumer<Runnable> assertDecorator;

        private ResponseDelegate(GraphQlResponse response, @Nullable java.util.function.Predicate<ResponseError> errorFilter, Consumer<Runnable> assertDecorator, Configuration jsonPathConfig) {
            this.jsonDoc = JsonPath.parse((Object)response.toMap(), (Configuration)jsonPathConfig);
            this.jsonContent = () -> ((DocumentContext)this.jsonDoc).jsonString();
            this.errors = response.getErrors();
            this.unexpectedErrors = new ArrayList<ResponseError>(this.errors);
            this.assertDecorator = assertDecorator;
            if (errorFilter != null) {
                this.filterErrors(errorFilter);
            }
        }

        String jsonContent() {
            return this.jsonContent.get();
        }

        String jsonContent(JsonPath jsonPath) {
            try {
                Object content = this.jsonDoc.read(jsonPath);
                return this.jsonDoc.configuration().jsonProvider().toJson(content);
            }
            catch (Exception ex) {
                throw new AssertionError("JSON parsing error", ex);
            }
        }

        <T> T read(JsonPath jsonPath, TypeRef<T> typeRef) {
            return (T)this.jsonDoc.read(jsonPath, typeRef);
        }

        void doAssert(Runnable task) {
            this.assertDecorator.accept(task);
        }

        boolean filterErrors(java.util.function.Predicate<ResponseError> predicate) {
            boolean filtered = false;
            for (ResponseError error : this.errors) {
                if (!predicate.test(error)) continue;
                this.unexpectedErrors.remove(error);
                filtered = true;
            }
            return filtered;
        }

        void expectErrors(java.util.function.Predicate<ResponseError> predicate) {
            boolean filtered = this.filterErrors(predicate);
            this.assertDecorator.accept(() -> AssertionErrors.assertTrue((String)"No matching errors.", (boolean)filtered));
        }

        void consumeErrors(Consumer<List<ResponseError>> consumer) {
            this.filterErrors(error -> true);
            consumer.accept(this.errors);
        }

        void verifyErrors() {
            this.assertDecorator.accept(() -> AssertionErrors.assertTrue((String)("Response has " + this.unexpectedErrors.size() + " unexpected error(s) of " + this.errors.size() + " total. If expected, please filter them out: " + this.unexpectedErrors), (boolean)CollectionUtils.isEmpty(this.unexpectedErrors)));
        }
    }
}

