/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.spi.mapper.MappingProvider;
import graphql.ExecutionInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.test.tester.AbstractDelegatingGraphQlTester;
import org.springframework.graphql.test.tester.AbstractGraphQlTesterBuilder;
import org.springframework.graphql.test.tester.EncoderDecoderMappingProvider;
import org.springframework.graphql.test.tester.ExecutionGraphQlServiceTester;
import org.springframework.graphql.test.tester.GraphQlServiceGraphQlTransport;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DefaultExecutionGraphQlServiceTesterBuilder
extends AbstractGraphQlTesterBuilder<DefaultExecutionGraphQlServiceTesterBuilder>
implements ExecutionGraphQlServiceTester.Builder<DefaultExecutionGraphQlServiceTesterBuilder> {
    private final ExecutionGraphQlService service;
    private final List<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>> executionInputConfigurers;
    @Nullable
    private Encoder<?> encoder;
    @Nullable
    private Decoder<?> decoder;

    DefaultExecutionGraphQlServiceTesterBuilder(ExecutionGraphQlService service) {
        Assert.notNull((Object)service, (String)"GraphQlService is required");
        this.service = service;
        this.executionInputConfigurers = new ArrayList<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>>();
    }

    DefaultExecutionGraphQlServiceTesterBuilder(GraphQlServiceGraphQlTransport transport) {
        this.service = transport.getGraphQlService();
        this.executionInputConfigurers = new ArrayList<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>>(transport.getExecutionInputConfigurers());
    }

    @Override
    public DefaultExecutionGraphQlServiceTesterBuilder configureExecutionInput(BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput> configurer) {
        this.executionInputConfigurers.add(configurer);
        return this;
    }

    @Override
    public DefaultExecutionGraphQlServiceTesterBuilder encoder(Encoder<?> encoder) {
        this.encoder = encoder;
        return this;
    }

    @Override
    public DefaultExecutionGraphQlServiceTesterBuilder decoder(Decoder<?> decoder) {
        this.decoder = decoder;
        return this;
    }

    @Override
    public ExecutionGraphQlServiceTester build() {
        this.registerJsonPathMappingProvider();
        GraphQlServiceGraphQlTransport transport = this.createTransport();
        GraphQlTester tester = super.buildGraphQlTester(transport);
        return new DefaultExecutionGraphQlServiceTester(tester, transport, this.getBuilderInitializer());
    }

    private void registerJsonPathMappingProvider() {
        if (this.encoder != null && this.decoder != null) {
            this.configureJsonPathConfig(config -> {
                EncoderDecoderMappingProvider provider = new EncoderDecoderMappingProvider(Collections.singletonList(this.encoder), Collections.singletonList(this.decoder));
                return config.mappingProvider((MappingProvider)provider);
            });
        }
    }

    private GraphQlServiceGraphQlTransport createTransport() {
        return new GraphQlServiceGraphQlTransport(this.service, this.executionInputConfigurers);
    }

    private static class DefaultExecutionGraphQlServiceTester
    extends AbstractDelegatingGraphQlTester
    implements ExecutionGraphQlServiceTester {
        private final GraphQlServiceGraphQlTransport transport;
        private final Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer;

        private DefaultExecutionGraphQlServiceTester(GraphQlTester tester, GraphQlServiceGraphQlTransport transport, Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer) {
            super(tester);
            Assert.notNull((Object)transport, (String)"GraphQlServiceTransport is required");
            Assert.notNull(builderInitializer, (String)"`builderInitializer` is required");
            this.transport = transport;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public DefaultExecutionGraphQlServiceTesterBuilder mutate() {
            DefaultExecutionGraphQlServiceTesterBuilder builder = new DefaultExecutionGraphQlServiceTesterBuilder(this.transport);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

