/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import java.net.URI;
import java.util.Map;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.test.tester.AbstractDirectGraphQlTransport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

final class WebGraphQlHandlerGraphQlTransport
extends AbstractDirectGraphQlTransport {
    private final URI url;
    private final HttpHeaders headers = new HttpHeaders();
    private final WebGraphQlHandler graphQlHandler;
    private final CodecConfigurer codecConfigurer;

    WebGraphQlHandlerGraphQlTransport(@Nullable URI url, HttpHeaders headers, WebGraphQlHandler handler, CodecConfigurer configurer) {
        this.url = url != null ? url : URI.create("");
        this.headers.addAll((MultiValueMap)headers);
        this.graphQlHandler = handler;
        this.codecConfigurer = configurer;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public WebGraphQlHandler getGraphQlHandler() {
        return this.graphQlHandler;
    }

    public CodecConfigurer getCodecConfigurer() {
        return this.codecConfigurer;
    }

    @Override
    protected Mono<ExecutionGraphQlResponse> executeInternal(ExecutionGraphQlRequest executionRequest) {
        String id = idGenerator.generateId().toString();
        Map body = executionRequest.toMap();
        WebGraphQlRequest webExecutionRequest = new WebGraphQlRequest(this.url, this.headers, body, id, null);
        return this.graphQlHandler.handleRequest(webExecutionRequest).cast(ExecutionGraphQlResponse.class);
    }
}

