/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.support.DefaultExecutionGraphQlRequest;
import org.springframework.graphql.support.DefaultExecutionGraphQlResponse;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.IdGenerator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractDirectGraphQlTransport
implements GraphQlTransport {
    protected static final IdGenerator idGenerator = new AlternativeJdkIdGenerator();

    AbstractDirectGraphQlTransport() {
    }

    public Mono<GraphQlResponse> execute(GraphQlRequest request) {
        return this.executeInternal(this.toExecutionRequest(request)).cast(GraphQlResponse.class);
    }

    public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
        return this.executeInternal(this.toExecutionRequest(request)).flatMapMany(response -> {
            try {
                Object data = response.getData();
                AssertionErrors.assertTrue((String)("Not a Publisher: " + data), (boolean)(data instanceof Publisher));
                List errors = response.getErrors();
                AssertionErrors.assertTrue((String)("Subscription errors: " + errors), (boolean)CollectionUtils.isEmpty((Collection)errors));
                return Flux.from((Publisher)((Publisher)data)).map(executionResult -> new DefaultExecutionGraphQlResponse(response.getExecutionInput(), executionResult));
            }
            catch (AssertionError ex) {
                throw new AssertionError(((Throwable)((Object)ex)).getMessage() + "\nRequest: " + request, (Throwable)((Object)ex));
            }
        });
    }

    private ExecutionGraphQlRequest toExecutionRequest(GraphQlRequest request) {
        return new DefaultExecutionGraphQlRequest(request.getDocument(), request.getOperationName(), request.getVariables(), request.getExtensions(), idGenerator.generateId().toString(), null);
    }

    protected abstract Mono<ExecutionGraphQlResponse> executeInternal(ExecutionGraphQlRequest var1);
}

