/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Collections;
import java.util.function.Consumer;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.test.tester.AbstractDelegatingGraphQlTester;
import org.springframework.graphql.test.tester.AbstractGraphQlTesterBuilder;
import org.springframework.graphql.test.tester.EncoderDecoderMappingProvider;
import org.springframework.graphql.test.tester.ExecutionGraphQlServiceTester;
import org.springframework.graphql.test.tester.GraphQlServiceGraphQlTransport;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DefaultExecutionGraphQlServiceTesterBuilder
extends AbstractGraphQlTesterBuilder<DefaultExecutionGraphQlServiceTesterBuilder>
implements ExecutionGraphQlServiceTester.Builder<DefaultExecutionGraphQlServiceTesterBuilder> {
    private final ExecutionGraphQlService service;
    @Nullable
    private Encoder<?> encoder;
    @Nullable
    private Decoder<?> decoder;

    DefaultExecutionGraphQlServiceTesterBuilder(ExecutionGraphQlService service) {
        Assert.notNull((Object)service, (String)"GraphQlService is required");
        this.service = service;
    }

    DefaultExecutionGraphQlServiceTesterBuilder(GraphQlServiceGraphQlTransport transport) {
        this.service = transport.getGraphQlService();
    }

    @Override
    public DefaultExecutionGraphQlServiceTesterBuilder encoder(Encoder<?> encoder) {
        this.encoder = encoder;
        return this;
    }

    @Override
    public DefaultExecutionGraphQlServiceTesterBuilder decoder(Decoder<?> decoder) {
        this.decoder = decoder;
        return this;
    }

    @Override
    public ExecutionGraphQlServiceTester build() {
        this.registerJsonPathMappingProvider();
        GraphQlServiceGraphQlTransport transport = new GraphQlServiceGraphQlTransport(this.service);
        GraphQlTester tester = super.buildGraphQlTester(transport);
        return new DefaultExecutionGraphQlServiceTester(tester, transport, this.getBuilderInitializer());
    }

    private void registerJsonPathMappingProvider() {
        if (this.encoder != null && this.decoder != null) {
            this.configureJsonPathConfig(config -> {
                EncoderDecoderMappingProvider provider = new EncoderDecoderMappingProvider(Collections.singletonList(this.encoder), Collections.singletonList(this.decoder));
                return config.mappingProvider((MappingProvider)provider);
            });
        }
    }

    private static class DefaultExecutionGraphQlServiceTester
    extends AbstractDelegatingGraphQlTester
    implements ExecutionGraphQlServiceTester {
        private final GraphQlServiceGraphQlTransport transport;
        private final Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer;

        private DefaultExecutionGraphQlServiceTester(GraphQlTester tester, GraphQlServiceGraphQlTransport transport, Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer) {
            super(tester);
            Assert.notNull((Object)transport, (String)"GraphQlServiceTransport is required");
            Assert.notNull(builderInitializer, (String)"`builderInitializer` is required");
            this.transport = transport;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public DefaultExecutionGraphQlServiceTesterBuilder mutate() {
            DefaultExecutionGraphQlServiceTesterBuilder builder = new DefaultExecutionGraphQlServiceTesterBuilder(this.transport);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

