/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.flex.security.FlexSessionInvalidatingAuthenticationListener;
import org.springframework.flex.security.SpringSecurityLoginCommand;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.util.FilterChainProxy;
import org.springframework.security.util.UrlMatcher;
import org.springframework.web.filter.RequestContextFilter;

public class SessionFixationProtectionPostProcessor
implements BeanFactoryPostProcessor,
ApplicationEventPublisherAware,
ApplicationListener {
    private static final Log log = LogFactory.getLog(SessionFixationProtectionPostProcessor.class);
    private boolean processed = false;
    private ApplicationEventPublisher applicationEventPublisher = null;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory.getBeanNamesForType(SpringSecurityLoginCommand.class).length > 0 && beanFactory.containsBean("_sessionFixationProtectionFilter")) {
            beanFactory.registerSingleton("_flexSessionAuthenticationListener", (Object)new FlexSessionInvalidatingAuthenticationListener());
            beanFactory.registerSingleton("_requestContextFilter", (Object)new PriorityOrderedRequestContextFilter());
        } else {
            this.processed = true;
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!this.processed && event instanceof ContextRefreshedEvent) {
            Object authFilterBean;
            ContextRefreshedEvent refreshEvent = (ContextRefreshedEvent)event;
            if (refreshEvent.getApplicationContext().containsBean("_formLoginFilter") && (authFilterBean = refreshEvent.getApplicationContext().getBean("_formLoginFilter")) != null && authFilterBean instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)authFilterBean).setApplicationEventPublisher(this.applicationEventPublisher);
            }
            if (refreshEvent.getApplicationContext().containsBean("_filterChainProxy")) {
                FilterChainProxy proxy = (FilterChainProxy)refreshEvent.getApplicationContext().getBean("_filterChainProxy", FilterChainProxy.class);
                UrlMatcher matcher = proxy.getMatcher();
                Object compiledPath = matcher.compile(matcher.getUniversalMatchPattern());
                if (proxy.getFilterChainMap().containsKey(compiledPath)) {
                    ((List)proxy.getFilterChainMap().get(compiledPath)).add(0, refreshEvent.getApplicationContext().getBean("_requestContextFilter"));
                }
                this.processed = true;
            } else {
                log.warn((Object)"Spring Security filter chain could not be auto-detected.  You must install the RequestContextFilter or RequestContextListenermanually in order for the flex session fixation protection integration to function as expected.");
                return;
            }
        }
    }

    public static final class PriorityOrderedRequestContextFilter
    extends RequestContextFilter
    implements Ordered {
        private static final int order = FilterChainOrder.getOrder((String)"FIRST");

        public int getOrder() {
            return order;
        }
    }
}

