/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.messaging.integration;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.services.MessageService;
import flex.messaging.services.messaging.adapters.MessagingAdapter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.channel.PollableChannel;
import org.springframework.integration.channel.SubscribableChannel;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.core.MessageHeaders;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.integration.message.MessageHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationAdapter
extends MessagingAdapter
implements MessageHandler,
InitializingBean,
BeanNameAware {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile MessageChannel messageChannel;
    private volatile boolean extractPayload = true;
    private final Set<Object> subscriberIds = new HashSet<Object>();
    private volatile AbstractEndpoint consumerEndpoint;

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.messageChannel, (String)"MessageChannel must not be null");
        if (this.messageChannel instanceof PollableChannel) {
            this.consumerEndpoint = new PollingConsumer((PollableChannel)this.messageChannel, (MessageHandler)this);
        } else if (this.messageChannel instanceof SubscribableChannel) {
            this.consumerEndpoint = new EventDrivenConsumer((SubscribableChannel)this.messageChannel, (MessageHandler)this);
        }
    }

    public void handleMessage(Message<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("received Integration Message: " + message));
        }
        AsyncMessage flexMessage = new AsyncMessage();
        flexMessage.setBody(message.getPayload());
        MessageHeaders headers = message.getHeaders();
        flexMessage.setMessageId(headers.getId().toString());
        flexMessage.setTimestamp(headers.getTimestamp().longValue());
        Long expirationDate = headers.getExpirationDate();
        if (expirationDate != null) {
            flexMessage.setTimeToLive(expirationDate - headers.getTimestamp());
        }
        for (Map.Entry header : headers.entrySet()) {
            String key = (String)header.getKey();
            if ("springintegration_id".equals(key) || "springintegration_timestamp".equals(key) || "springintegration_expirationDate".equals(key)) continue;
            flexMessage.setHeader(key, header.getValue());
        }
        flexMessage.setDestination(this.getDestination().getId());
        MessageService messageService = (MessageService)this.getDestination().getService();
        messageService.pushMessageToClients((flex.messaging.messages.Message)flexMessage, true);
        messageService.sendPushMessageFromPeer((flex.messaging.messages.Message)flexMessage, true);
    }

    public boolean handlesSubscriptions() {
        return true;
    }

    public Object invoke(flex.messaging.messages.Message flexMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("received Flex Message: " + flexMessage));
        }
        GenericMessage message = null;
        if (this.extractPayload) {
            Map headers = flexMessage.getHeaders();
            headers.put("flex_client_id", flexMessage.getClientId());
            headers.put("flex_destination_id", flexMessage.getDestination());
            long timestamp = flexMessage.getTimestamp();
            message = MessageBuilder.withPayload((Object)flexMessage.getBody()).copyHeaders(headers).setHeader("springintegration_id", (Object)flexMessage.getMessageId()).setHeader("springintegration_timestamp", (Object)timestamp).setExpirationDate(Long.valueOf(timestamp + flexMessage.getTimeToLive())).build();
        } else {
            message = new GenericMessage((Object)flexMessage);
        }
        this.messageChannel.send((Message)message);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object manage(CommandMessage commandMessage) {
        String clientId = (String)commandMessage.getClientId();
        if (commandMessage.getOperation() == 0) {
            this.subscriberIds.add(clientId);
            AbstractEndpoint abstractEndpoint = this.consumerEndpoint;
            synchronized (abstractEndpoint) {
                if (!this.consumerEndpoint.isRunning()) {
                    this.consumerEndpoint.start();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("client [" + clientId + "] subscribed to destination [" + this.getDestination().getId() + "]"));
            }
        } else if (commandMessage.getOperation() == 1) {
            this.subscriberIds.remove(clientId);
            AbstractEndpoint abstractEndpoint = this.consumerEndpoint;
            synchronized (abstractEndpoint) {
                if (this.subscriberIds.isEmpty() && this.consumerEndpoint.isRunning()) {
                    this.consumerEndpoint.stop();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("client [" + clientId + "] unsubscribed from destination [" + this.getDestination().getId() + "]"));
            }
        }
        return null;
    }

    public void setBeanName(String beanName) {
        this.setId(beanName);
    }

    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public void start() {
        super.start();
    }
}

