/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.springframework.graal.support.SpringFeature;
import org.springframework.graal.type.Hint;
import org.springframework.graal.type.Type;
import org.springframework.graal.type.TypeSystem;
import sbg.asm.signature.SignatureReader;
import sbg.asm.signature.SignatureVisitor;
import sbg.asm.tree.AnnotationNode;
import sbg.asm.tree.MethodNode;

public class Method {
    private MethodNode mn;
    private TypeSystem typeSystem;

    public Method(MethodNode mn, TypeSystem ts) {
        this.mn = mn;
        this.typeSystem = ts;
    }

    public String toString() {
        return this.mn.name + this.mn.desc;
    }

    public String getName() {
        return this.mn.name;
    }

    public String getDesc() {
        return this.mn.desc;
    }

    public List<Hint> getHints() {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (this.mn.visibleAnnotations != null) {
            for (AnnotationNode an : this.mn.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) {
                    SpringFeature.log("Couldn't resolve " + an.desc + " annotation type whilst searching for hints on " + this.getName());
                    continue;
                }
                Stack<Type> s = new Stack<Type>();
                annotationType.collectHints(an, hints, new HashSet<AnnotationNode>(), s);
            }
        }
        return hints.size() == 0 ? Collections.emptyList() : hints;
    }

    public List<Type> getAnnotationTypes() {
        ArrayList<Type> results = null;
        if (this.mn.visibleAnnotations != null) {
            for (AnnotationNode an : this.mn.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) continue;
                if (results == null) {
                    results = new ArrayList<Type>();
                }
                results.add(annotationType);
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    public Set<Type> getSignatureTypes() {
        HashSet<Type> signatureTypes = new HashSet<Type>();
        if (this.mn.signature == null) {
            sbg.asm.Type methodType = sbg.asm.Type.getMethodType(this.mn.desc);
            Type t = this.typeSystem.resolve(methodType.getReturnType(), true);
            if (t == null) {
                SpringFeature.log("Can't resolve the type used in this @Bean method: " + this.mn.name + this.mn.desc + ": " + methodType.getDescriptor());
            } else {
                signatureTypes.add(t);
            }
            for (sbg.asm.Type at : methodType.getArgumentTypes()) {
                t = this.typeSystem.resolve(methodType.getReturnType(), true);
                if (t == null) {
                    SpringFeature.log("Can't resolve the type used in this @Bean method: " + this.mn.name + this.mn.desc + ": " + at.getDescriptor());
                    continue;
                }
                signatureTypes.add(t);
            }
        } else {
            SignatureReader reader = new SignatureReader(this.mn.signature);
            TypesFromSignatureCollector tc = new TypesFromSignatureCollector();
            reader.accept(tc);
            Set<String> collectedTypes = tc.getTypes();
            for (String s : collectedTypes) {
                Type t = this.typeSystem.resolveDotted(s, true);
                if (t == null) {
                    SpringFeature.log("Can't resolve the type used in this @Bean method: " + this.mn.name + this.mn.desc + ": " + s);
                    continue;
                }
                signatureTypes.add(t);
            }
        }
        return signatureTypes;
    }

    public Type getReturnType() {
        sbg.asm.Type methodType = sbg.asm.Type.getMethodType(this.mn.desc);
        Type returnType = this.typeSystem.resolve(methodType.getReturnType(), true);
        return returnType;
    }

    public List<Type> getParameterTypes() {
        ArrayList<Type> results = null;
        sbg.asm.Type[] parameterTypes = sbg.asm.Type.getArgumentTypes(this.mn.desc);
        if (parameterTypes != null) {
            for (sbg.asm.Type t : parameterTypes) {
                if (results == null) {
                    results = new ArrayList<Type>();
                }
                results.add(this.typeSystem.resolve(t, true));
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    static class TypesFromSignatureCollector
    extends SignatureVisitor {
        Set<String> types = null;

        public TypesFromSignatureCollector() {
            super(458752);
        }

        @Override
        public void visitClassType(String name) {
            if (this.types == null) {
                this.types = new HashSet<String>();
            }
            this.types.add(name);
        }

        public Set<String> getTypes() {
            if (this.types == null) {
                return Collections.emptySet();
            }
            return this.types;
        }
    }
}

