/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.support;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.ResourcesFeature;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.hosted.DynamicProxyFeature;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.graal.support.ConfigOptions;
import org.springframework.graal.support.DynamicProxiesHandler;
import org.springframework.graal.support.InitializationHandler;
import org.springframework.graal.support.ReflectionHandler;
import org.springframework.graal.support.ResourcesHandler;

@AutomaticFeature
public class SpringFeature
implements Feature {
    private ReflectionHandler reflectionHandler;
    private DynamicProxiesHandler dynamicProxiesHandler;
    private ResourcesHandler resourcesHandler;
    private InitializationHandler buildTimeInitializationHandler;

    public SpringFeature() {
        System.out.println(" ____             _               _____          _                  \n/ ___| _ __  _ __(_)_ __   __ _  |  ___|__  __ _| |_ _   _ _ __ ___ \n\\___ \\| '_ \\| '__| | '_ \\ / _` | | |_ / _ \\/ _` | __| | | | '__/ _ \\\n ___) | |_) | |  | | | | | (_| | |  _|  __/ (_| | |_| |_| | | |  __/\n|____/| .__/|_|  |_|_| |_|\\__, | |_|  \\___|\\__,_|\\__|\\__,_|_|  \\___|\n      |_|                 |___/                                     \n");
        if (!ConfigOptions.isVerbose()) {
            System.out.println("Use -Dspring.graal.verbose=true on native-image call to see more detailed information from the feature");
        }
        if (!ConfigOptions.isInitializationModeOnly()) {
            this.reflectionHandler = new ReflectionHandler();
            this.dynamicProxiesHandler = new DynamicProxiesHandler();
            this.resourcesHandler = new ResourcesHandler(this.reflectionHandler, this.dynamicProxiesHandler);
        }
        this.buildTimeInitializationHandler = new InitializationHandler();
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return true;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        ArrayList<Class<? extends Feature>> fs = new ArrayList<Class<? extends Feature>>();
        fs.add(DynamicProxyFeature.class);
        fs.add(ResourcesFeature.class);
        fs.add(ReflectionFeature.class);
        return fs;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (!ConfigOptions.isInitializationModeOnly()) {
            this.reflectionHandler.register(access);
            this.dynamicProxiesHandler.register(access);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (!ConfigOptions.isInitializationModeOnly()) {
            this.resourcesHandler.register(access);
        }
        this.buildTimeInitializationHandler.register(access);
        if (!ConfigOptions.isInitializationModeOnly()) {
            System.out.println("Number of types dynamically registered for reflective access: #" + this.reflectionHandler.getTypesRegisteredForReflectiveAccessCount());
            this.reflectionHandler.dump();
        }
    }

    public static void log(String msg) {
        if (ConfigOptions.isVerbose()) {
            System.out.println(msg);
        }
    }
}

