/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.graal.domain.resources.ResourcesDescriptor;
import org.springframework.graal.domain.resources.ResourcesJsonConverter;
import org.springframework.graal.json.JSONArray;
import org.springframework.graal.json.JSONObject;

public class ResourcesJsonMarshaller {
    private static final int BUFFER_SIZE = 4098;

    public void write(ResourcesDescriptor metadata, OutputStream outputStream) throws IOException {
        try {
            ResourcesJsonConverter converter = new ResourcesJsonConverter();
            JSONObject jsonObject = converter.toJsonArray(metadata);
            outputStream.write(jsonObject.toString(2).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IllegalStateException(ex);
        }
    }

    public static ResourcesDescriptor read(String input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            ResourcesDescriptor resourcesDescriptor = ResourcesJsonMarshaller.read(bais);
            return resourcesDescriptor;
        }
    }

    public static ResourcesDescriptor read(byte[] input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input);){
            ResourcesDescriptor resourcesDescriptor = ResourcesJsonMarshaller.read(bais);
            return resourcesDescriptor;
        }
    }

    public static ResourcesDescriptor read(InputStream inputStream) throws Exception {
        ResourcesDescriptor metadata = ResourcesJsonMarshaller.toResourcesDescriptor(new JSONObject(ResourcesJsonMarshaller.toString(inputStream)));
        return metadata;
    }

    private static ResourcesDescriptor toResourcesDescriptor(JSONObject object) throws Exception {
        int i;
        ResourcesDescriptor rd = new ResourcesDescriptor();
        JSONArray array = object.getJSONArray("bundles");
        for (i = 0; i < array.length(); ++i) {
            rd.addBundle(array.getJSONObject(i).getString("name"));
        }
        array = object.getJSONArray("resources");
        for (i = 0; i < array.length(); ++i) {
            rd.add(array.getJSONObject(i).getString("pattern"));
        }
        return rd;
    }

    private static String toString(InputStream inputStream) throws IOException {
        int bytesRead;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        char[] buffer = new char[4098];
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }
}

