/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.reflect;

import org.springframework.graal.domain.reflect.MemberDescriptor;

public final class FieldDescriptor
extends MemberDescriptor
implements Comparable<FieldDescriptor> {
    private boolean allowWrite = false;
    private boolean allowUnsafeAccess = false;

    FieldDescriptor(String name, boolean allowWrite, boolean allowUnsafeAccess) {
        super(name);
        this.allowWrite = allowWrite;
        this.allowUnsafeAccess = allowUnsafeAccess;
    }

    public boolean isAllowWrite() {
        return this.allowWrite;
    }

    public boolean isAllowUnsafeAccess() {
        return this.allowUnsafeAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDescriptor other = (FieldDescriptor)o;
        boolean result = true;
        result = result && this.nullSafeEquals(this.name, other.name);
        result = result && this.nullSafeEquals(this.allowWrite, other.allowWrite);
        result = result && this.nullSafeEquals(this.allowUnsafeAccess, other.allowUnsafeAccess);
        return result;
    }

    public int hashCode() {
        int result = this.nullSafeHashCode(this.name);
        result = 31 * result + this.nullSafeHashCode(this.allowWrite);
        result = 31 * result + this.nullSafeHashCode(this.allowUnsafeAccess);
        return result;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.name);
        this.buildToStringProperty(string, "name", this.name);
        this.buildToStringProperty(string, "allowWrite", this.allowWrite);
        this.buildToStringProperty(string, "allowUnsafeAccess", this.allowUnsafeAccess);
        return string.toString();
    }

    @Override
    public int compareTo(FieldDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    public void setAllowWrite(boolean b) {
        this.allowWrite = b;
    }

    public void setAllowUnsafeAccess(boolean b) {
        this.allowUnsafeAccess = b;
    }
}

