/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.reflect;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.graal.domain.reflect.FieldDescriptor;
import org.springframework.graal.domain.reflect.Flag;
import org.springframework.graal.domain.reflect.MethodDescriptor;

public final class ClassDescriptor
implements Comparable<ClassDescriptor> {
    private String name;
    private List<FieldDescriptor> fields;
    private List<MethodDescriptor> methods;
    private Set<Flag> flags;

    ClassDescriptor() {
    }

    ClassDescriptor(String name, List<FieldDescriptor> fields, List<MethodDescriptor> methods, Set<Flag> flags) {
        this.name = name;
        this.fields = fields;
        this.methods = methods;
        this.flags = flags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDescriptor other = (ClassDescriptor)o;
        boolean result = true;
        result = result && this.nullSafeEquals(this.name, other.name);
        result = result && this.nullSafeEquals(this.flags, other.flags);
        result = result && this.nullSafeEquals(this.fields, other.fields);
        result = result && this.nullSafeEquals(this.methods, other.methods);
        return result;
    }

    public int hashCode() {
        int result = this.nullSafeHashCode(this.name);
        result = 31 * result + this.nullSafeHashCode(this.flags);
        result = 31 * result + this.nullSafeHashCode(this.fields);
        result = 31 * result + this.nullSafeHashCode(this.methods);
        return result;
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private int nullSafeHashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.name);
        this.buildToStringProperty(string, "setFlags", this.flags);
        this.buildToStringProperty(string, "fields", this.fields);
        this.buildToStringProperty(string, "methods", this.methods);
        return string.toString();
    }

    protected void buildToStringProperty(StringBuilder string, String property, Object value) {
        if (value != null) {
            string.append(" ").append(property).append(":").append(value);
        }
    }

    @Override
    public int compareTo(ClassDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public List<MethodDescriptor> getMethods() {
        return this.methods;
    }

    public static ClassDescriptor of(String name) {
        ClassDescriptor cd = new ClassDescriptor();
        cd.setName(name);
        return cd;
    }

    public void setFlag(Flag f) {
        if (this.flags == null) {
            this.flags = new TreeSet<Flag>();
        }
        this.flags.add(f);
    }

    public void unsetFlag(Flag f) {
        if (this.flags == null) {
            return;
        }
        this.flags.remove((Object)f);
    }

    public void addMethodDescriptor(MethodDescriptor methodDescriptor) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodDescriptor>();
        }
        this.methods.add(methodDescriptor);
    }

    public void addFieldDescriptor(FieldDescriptor fieldDescriptor) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldDescriptor>();
        }
        this.fields.add(fieldDescriptor);
    }

    public void merge(ClassDescriptor cd) {
        if (cd.getFlags() != null) {
            for (Flag flag : cd.getFlags()) {
                this.setFlag(flag);
            }
        }
        if (cd.getFields() != null) {
            for (FieldDescriptor fd : cd.getFields()) {
                FieldDescriptor existingSimilarOne = null;
                for (FieldDescriptor existingFd : this.getFields()) {
                    if (!existingFd.getName().equals(fd.getName())) continue;
                    existingSimilarOne = existingFd;
                    break;
                }
                if (existingSimilarOne != null) {
                    if (!fd.isAllowWrite()) continue;
                    existingSimilarOne.setAllowWrite(true);
                    continue;
                }
                this.addFieldDescriptor(fd);
            }
        }
        if (cd.getMethods() != null) {
            for (MethodDescriptor methodDescriptor : cd.getMethods()) {
                if (this.containsMethodDescriptor(methodDescriptor)) continue;
                this.addMethodDescriptor(methodDescriptor);
            }
        }
    }

    private boolean containsMethodDescriptor(MethodDescriptor methodDescriptor) {
        return this.methods == null ? false : this.methods.contains(methodDescriptor);
    }

    public MethodDescriptor getMethodDescriptor(String name, String ... parameterTypes) {
        if (this.methods != null) {
            MethodDescriptor toFind = MethodDescriptor.of(name, parameterTypes);
            for (MethodDescriptor md : this.methods) {
                if (!md.equals(toFind)) continue;
                return md;
            }
        }
        return null;
    }

    public boolean contains(MethodDescriptor toFind) {
        if (this.methods != null) {
            for (MethodDescriptor md : this.methods) {
                if (!md.equals(toFind)) continue;
                return true;
            }
        }
        return false;
    }
}

