/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.buildtimeinit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.graal.domain.buildtimeinit.InitializationDescriptor;
import org.springframework.graal.domain.buildtimeinit.InitializationJsonConverter;
import org.springframework.graal.json.JSONArray;
import org.springframework.graal.json.JSONObject;

public class InitializationJsonMarshaller {
    private static final int BUFFER_SIZE = 4098;

    public void write(InitializationDescriptor metadata, OutputStream outputStream) throws IOException {
        try {
            InitializationJsonConverter converter = new InitializationJsonConverter();
            JSONObject jsonObject = converter.toJsonArray(metadata);
            outputStream.write(jsonObject.toString(2).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IllegalStateException(ex);
        }
    }

    public static InitializationDescriptor read(String input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            InitializationDescriptor initializationDescriptor = InitializationJsonMarshaller.read(bais);
            return initializationDescriptor;
        }
    }

    public static InitializationDescriptor read(byte[] input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input);){
            InitializationDescriptor initializationDescriptor = InitializationJsonMarshaller.read(bais);
            return initializationDescriptor;
        }
    }

    public static InitializationDescriptor read(InputStream inputStream) throws Exception {
        InitializationDescriptor metadata = InitializationJsonMarshaller.toDelayInitDescriptor(new JSONObject(InitializationJsonMarshaller.toString(inputStream)));
        return metadata;
    }

    private static InitializationDescriptor toDelayInitDescriptor(JSONObject object) throws Exception {
        JSONObject jsonObject;
        int i;
        InitializationDescriptor rd = new InitializationDescriptor();
        JSONArray array = object.getJSONArray("buildTimeInitialization");
        for (i = 0; i < array.length(); ++i) {
            jsonObject = array.getJSONObject(i);
            if (jsonObject.has("class")) {
                rd.addBuildtimeClass(jsonObject.getString("class"));
                continue;
            }
            if (jsonObject.has("package")) {
                rd.addBuildtimePackage(jsonObject.getString("package"));
                continue;
            }
            throw new IllegalStateException("Unrecognized entry in JSON: " + jsonObject.toString());
        }
        array = object.getJSONArray("runtimeInitialization");
        for (i = 0; i < array.length(); ++i) {
            jsonObject = array.getJSONObject(i);
            if (jsonObject.has("class")) {
                rd.addRuntimeClass(jsonObject.getString("class"));
                continue;
            }
            if (jsonObject.has("package")) {
                rd.addRuntimePackage(jsonObject.getString("package"));
                continue;
            }
            throw new IllegalStateException("Unrecognized entry in JSON: " + jsonObject.toString());
        }
        return rd;
    }

    private static String toString(InputStream inputStream) throws IOException {
        int bytesRead;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        char[] buffer = new char[4098];
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }
}

