/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.convert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.springframework.core.convert.converter.Converter;
import org.springframework.yarn.integration.convert.MindDataConversionException;
import org.springframework.yarn.integration.ip.mind.MindRpcMessageHolder;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;

public class MindObjectToHolderConverter
implements Converter<BaseObject, MindRpcMessageHolder> {
    private ObjectMapper objectMapper;

    public MindObjectToHolderConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public MindRpcMessageHolder convert(BaseObject source) {
        try {
            String type = source.getType();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("type", type);
            byte[] content = this.objectMapper.writeValueAsBytes((Object)source);
            return new MindRpcMessageHolder(headers, content);
        }
        catch (JsonProcessingException e) {
            throw new MindDataConversionException("Failed to convert source object.", e);
        }
    }
}

