/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.yarn.integration.convert.MindDataConversionException;
import org.springframework.yarn.integration.ip.mind.MindRpcMessageHolder;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;

public class MindHolderToObjectConverter
implements Converter<MindRpcMessageHolder, BaseObject> {
    private static final Log log = LogFactory.getLog(MindHolderToObjectConverter.class);
    private ObjectMapper objectMapper;
    private String[] basePackage;
    private Map<String, Class<? extends BaseObject>> classCache;

    public MindHolderToObjectConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.classCache = new ConcurrentHashMap<String, Class<? extends BaseObject>>();
    }

    public MindHolderToObjectConverter(ObjectMapper objectMapper, String basePackage) {
        this(objectMapper, new String[]{basePackage});
    }

    public MindHolderToObjectConverter(ObjectMapper objectMapper, String[] basePackage) {
        this.objectMapper = objectMapper;
        this.basePackage = basePackage;
        this.classCache = new ConcurrentHashMap<String, Class<? extends BaseObject>>();
    }

    public BaseObject convert(MindRpcMessageHolder source) {
        Map<String, String> headers = source.getHeaders();
        String type = headers.get("type").trim();
        byte[] content = source.getContent();
        Class<?> clazz = this.resolveClass(type);
        if (clazz == null) {
            throw new MindDataConversionException("Failed to convert source object. Can't resolve type=" + type);
        }
        try {
            BaseObject object = (BaseObject)this.objectMapper.readValue(content, clazz);
            return object;
        }
        catch (Exception e) {
            throw new MindDataConversionException("Failed to convert source object.", e);
        }
    }

    public void setBasePackage(String[] basePackage) {
        this.basePackage = basePackage;
    }

    private Class<?> resolveClass(String type) {
        String clazzName = type;
        Class clazz = this.classCache.get(clazzName);
        if (clazz == null) {
            try {
                clazz = ClassUtils.resolveClassName((String)clazzName, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (clazz != null) {
                this.classCache.put(clazzName, clazz);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        if (!ObjectUtils.isEmpty((Object[])this.basePackage)) {
            for (String base : this.basePackage) {
                clazzName = base + "." + type;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying to resolve type " + type + " as " + clazzName));
                }
                clazz = this.classCache.get(clazzName);
                if (log.isDebugEnabled() && clazz != null) {
                    log.debug((Object)("Found " + clazz + " from a cache"));
                }
                if (clazz == null) {
                    try {
                        clazz = ClassUtils.resolveClassName((String)clazzName, (ClassLoader)this.getClass().getClassLoader());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (clazz != null) {
                        this.classCache.put(clazzName, clazz);
                    }
                }
                if (clazz == null) continue;
                return clazz;
            }
        }
        return clazz;
    }
}

