/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.ip.tcp.TcpOutboundGateway;
import org.springframework.integration.ip.tcp.connection.TcpNetClientConnectionFactory;
import org.springframework.util.StringUtils;
import org.springframework.yarn.config.YarnNamespaceUtils;
import org.springframework.yarn.integration.IntegrationAppmasterServiceClientFactoryBean;
import org.springframework.yarn.integration.ip.mind.MindRpcSerializer;
import org.w3c.dom.Element;

public class IntegrationAmServiceClientParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return IntegrationAppmasterServiceClientFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        boolean hasResponseChannelAttribute = element.hasAttribute("response-channel");
        boolean hasRequestChannelAttribute = element.hasAttribute("request-channel");
        if (!hasResponseChannelAttribute && !hasRequestChannelAttribute) {
            BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.genericBeanDefinition(DirectChannel.class);
            AbstractBeanDefinition beanDef = defBuilder.getBeanDefinition();
            String reqChannelBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, reqChannelBeanName));
            builder.addPropertyReference("requestChannel", reqChannelBeanName);
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(QueueChannel.class);
            beanDef = defBuilder.getBeanDefinition();
            String repChannelBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, repChannelBeanName));
            builder.addPropertyReference("responseChannel", repChannelBeanName);
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(MindRpcSerializer.class);
            beanDef = defBuilder.getBeanDefinition();
            String serializerBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, serializerBeanName));
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(TcpNetClientConnectionFactory.class);
            String host = element.hasAttribute("host") ? element.getAttribute("host") : "localhost";
            String port = element.hasAttribute("port") ? element.getAttribute("port") : "0";
            defBuilder.addConstructorArgValue((Object)host);
            defBuilder.addConstructorArgValue((Object)port);
            defBuilder.addPropertyReference("serializer", serializerBeanName);
            defBuilder.addPropertyReference("deserializer", serializerBeanName);
            beanDef = defBuilder.getBeanDefinition();
            String conFactoryBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, conFactoryBeanName));
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(TcpOutboundGateway.class);
            defBuilder.addPropertyReference("connectionFactory", conFactoryBeanName);
            defBuilder.addPropertyReference("outputChannel", reqChannelBeanName);
            defBuilder.addPropertyReference("replyChannel", repChannelBeanName);
            beanDef = defBuilder.getBeanDefinition();
            String gatewayBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, gatewayBeanName));
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConsumerEndpointFactoryBean.class);
            defBuilder.addPropertyReference("handler", gatewayBeanName);
            defBuilder.addPropertyValue("inputChannelName", (Object)reqChannelBeanName);
            beanDef = defBuilder.getBeanDefinition();
            String consumerBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, consumerBeanName));
        } else if (hasResponseChannelAttribute && hasRequestChannelAttribute) {
            YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-channel");
            YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"response-channel");
        } else {
            parserContext.getReaderContext().error("Both request-channel and response-channel needs to either exist together or omitted completely.", (Object)element);
        }
        YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"service-impl");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"object-mapper");
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "yarnAmserviceClient";
        }
        return name;
    }
}

