/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.util.Assert;
import org.springframework.yarn.boot.app.YarnShutdownApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnShutdownCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "shutdown";
    public static final String DEFAULT_DESC = "Shutdown application";

    public YarnShutdownCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new ShutdownOptionHandler());
    }

    public YarnShutdownCommand(ShutdownOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnShutdownCommand(String name, String description, ShutdownOptionHandler handler) {
        super(name, description, handler);
    }

    public static class ShutdownOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private OptionSpec<String> applicationIdOption;

        protected final void options() {
            this.applicationIdOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_ID, "Specify YARN application id").withRequiredArg();
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            Assert.hasText((String)appId, (String)"Application Id must be defined");
            YarnShutdownApplication app = new YarnShutdownApplication();
            Properties appProperties = new Properties();
            appProperties.setProperty("spring.yarn.internal.YarnShutdownApplication.applicationId", appId);
            app.appProperties(appProperties);
            this.handleApplicationRun(app);
        }

        public OptionSpec<String> getApplicationIdOption() {
            return this.applicationIdOption;
        }
    }
}

