/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.util.Assert;
import org.springframework.yarn.boot.app.YarnKillApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnKillCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "kill";
    public static final String DEFAULT_DESC = "Kill application";

    public YarnKillCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new KillOptionHandler());
    }

    public YarnKillCommand(KillOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnKillCommand(String name, String description, KillOptionHandler handler) {
        super(name, description, handler);
    }

    public static class KillOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private OptionSpec<String> applicationIdOption;

        protected final void options() {
            this.applicationIdOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_ID, "Specify YARN application id").withRequiredArg();
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            Assert.hasText((String)appId, (String)"Application Id must be defined");
            YarnKillApplication app = new YarnKillApplication();
            Properties appProperties = new Properties();
            appProperties.setProperty("spring.yarn.internal.YarnKillApplication.applicationId", appId);
            app.appProperties(appProperties);
            this.handleApplicationRun(app);
        }

        public OptionSpec<String> getApplicationIdOption() {
            return this.applicationIdOption;
        }
    }
}

