/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.util.Assert;
import org.springframework.yarn.boot.app.YarnContainerClusterApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnClustersInfoCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "clustersinfo";
    public static final String DEFAULT_DESC = "List clusters";

    public YarnClustersInfoCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new ClustersInfoOptionHandler());
    }

    public YarnClustersInfoCommand(ClustersInfoOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnClustersInfoCommand(String name, String description, ClustersInfoOptionHandler handler) {
        super(name, description, handler);
    }

    public static class ClustersInfoOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private OptionSpec<String> applicationIdOption;

        protected final void options() {
            this.applicationIdOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_ID, "Specify YARN application id").withRequiredArg();
        }

        @Override
        protected void verifyOptionSet(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            Assert.hasText((String)appId, (String)"Application Id must be defined");
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            YarnContainerClusterApplication app = new YarnContainerClusterApplication();
            Properties appProperties = new Properties();
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.operation", "CLUSTERSINFO");
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.applicationId", appId);
            app.appProperties(appProperties);
            this.handleApplicationRun(app);
        }

        public OptionSpec<String> getApplicationIdOption() {
            return this.applicationIdOption;
        }
    }
}

