/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.app.YarnContainerClusterApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnClusterDestroyCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "clusterdestroy";
    public static final String DEFAULT_DESC = "Destroy cluster";

    public YarnClusterDestroyCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new ClusterDestroyOptionHandler());
    }

    public YarnClusterDestroyCommand(ClusterDestroyOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnClusterDestroyCommand(String name, String description, ClusterDestroyOptionHandler handler) {
        super(name, description, handler);
    }

    public static class ClusterDestroyOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private OptionSpec<String> applicationIdOption;
        private OptionSpec<String> clusterIdOption;

        protected final void options() {
            this.applicationIdOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_ID, "Specify YARN application id").withRequiredArg();
            this.clusterIdOption = this.option(CliSystemConstants.OPTIONS_CLUSTER_ID, "Specify cluster id").withRequiredArg();
        }

        @Override
        protected void verifyOptionSet(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            String clusterId = (String)options.valueOf(this.clusterIdOption);
            Assert.state((StringUtils.hasText((String)appId) && StringUtils.hasText((String)clusterId) ? 1 : 0) != 0, (String)"Cluster Id and Application Id must be defined");
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            String versionId = (String)options.valueOf(this.clusterIdOption);
            YarnContainerClusterApplication app = new YarnContainerClusterApplication();
            Properties appProperties = new Properties();
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.operation", "CLUSTERDESTROY");
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.applicationId", appId);
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.clusterId", versionId);
            app.appProperties(appProperties);
            this.handleApplicationRun(app);
        }

        public OptionSpec<String> getApplicationIdOption() {
            return this.applicationIdOption;
        }

        public OptionSpec<String> getClusterIdOption() {
            return this.clusterIdOption;
        }
    }
}

