/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;
import org.springframework.yarn.boot.app.ClientApplicationRunner;

public class AbstractApplicationCommand
extends OptionParsingCommand {
    protected AbstractApplicationCommand(String name, String description, OptionHandler handler) {
        super(name, description, handler);
    }

    public String getUsageHelp() {
        return "[options]";
    }

    public static abstract class ApplicationOptionHandler<R>
    extends OptionHandler {
        protected final ExitStatus run(OptionSet options) throws Exception {
            this.verifyOptionSet(options);
            this.runApplication(options);
            return ExitStatus.OK;
        }

        protected void verifyOptionSet(OptionSet options) throws Exception {
        }

        protected abstract void runApplication(OptionSet var1) throws Exception;

        protected boolean isFlagOn(OptionSet options, OptionSpec<Boolean> option) {
            return options.has(option) ? (Boolean)options.valueOf(option) : false;
        }

        protected void handleOutput(String output) {
            Log.info((String)output);
        }

        protected void handleApplicationRun(ClientApplicationRunner<R> app) {
            this.handleApplicationRun(app, new String[0]);
        }

        protected void handleApplicationRun(ClientApplicationRunner<R> app, String ... args) {
            Object run = app.run(args);
            if (run != null) {
                this.handleOutput(run.toString());
            }
        }
    }
}

