/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Point;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GeoDistanceFunction
extends AbstractFunction {
    private static final String OPERATION = "geodist";

    private GeoDistanceFunction(@Nullable Field field, @Nullable Point location) {
        super(GeoDistanceFunction.toArgs(field, location));
    }

    public static GeoDistanceFunction geodist() {
        return new GeoDistanceFunction(null, null);
    }

    private static List<Object> toArgs(@Nullable Field field, @Nullable Point location) {
        if (field == null || location == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(field, location);
    }

    public static Builder distanceFrom(String fieldName) {
        Assert.hasText((String)fieldName, (String)"FieldName must not be empty!");
        return GeoDistanceFunction.distanceFrom(new SimpleField(fieldName));
    }

    public static Builder distanceFrom(Field field) {
        Assert.notNull((Object)field, (String)"Field cannot be 'null' for geodistance function.");
        return new Builder(field);
    }

    @Override
    public String toSolrFunction(Function.Context context) {
        if (Function.Context.Target.PROJECTION.equals((Object)context.getTarget())) {
            return "geodist()";
        }
        StringBuilder sb = new StringBuilder("{!func}geodist()");
        return sb.toString();
    }

    @Override
    public Map<String, String> getArgumentMap(Function.Context context) {
        if (CollectionUtils.isEmpty((Collection)this.getArguments())) {
            return super.getArgumentMap(context);
        }
        LinkedHashMap<String, String> argumentMap = new LinkedHashMap<String, String>();
        argumentMap.put("pt", context.convert(this.getArguments().get(1)));
        argumentMap.put("sfield", context.convert(this.getArguments().get(0)));
        return argumentMap;
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private final Field field;

        public Builder(Field field) {
            Assert.notNull((Object)field, (String)"field must not be an null.");
            this.field = field;
        }

        public GeoDistanceFunction to(Point location) {
            Assert.notNull((Object)location, (String)"Location for geodist function must not be 'null'");
            return new GeoDistanceFunction(this.field, location);
        }

        public GeoDistanceFunction to(double latitude, double longitude) {
            return this.to(new Point(latitude, longitude));
        }
    }
}

