/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.config;

import java.util.Collection;
import java.util.Collections;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.RequestMethod;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.convert.MappingSolrConverter;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.convert.SolrCustomConversions;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.schema.SolrPersistentEntitySchemaCreator;
import org.springframework.data.solr.server.SolrClientFactory;

@Configuration
public abstract class AbstractSolrConfiguration {
    @Bean
    public SolrTemplate solrTemplate() {
        return new SolrTemplate(this.solrClientFactory(), this.solrConverter(), this.defaultRequestMethod());
    }

    @Bean
    public SolrConverter solrConverter() {
        MappingSolrConverter solrConverter = new MappingSolrConverter(this.solrMappingContext());
        solrConverter.setCustomConversions(this.customConversions());
        return solrConverter;
    }

    @Bean
    protected MappingContext solrMappingContext() {
        return new SimpleSolrMappingContext(new SolrPersistentEntitySchemaCreator(this.solrClientFactory()).enable(this.schemaSupport()));
    }

    @Bean
    public abstract SolrClientFactory solrClientFactory();

    protected CustomConversions customConversions() {
        return new SolrCustomConversions(Collections.emptyList());
    }

    protected RequestMethod defaultRequestMethod() {
        return RequestMethod.GET;
    }

    protected Collection<SolrPersistentEntitySchemaCreator.Feature> schemaSupport() {
        return Collections.emptySet();
    }
}

