/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.UncategorizedSolrException;
import org.springframework.data.solr.core.QueryParser;
import org.springframework.data.solr.core.QueryParserBase;
import org.springframework.data.solr.core.QueryParsers;
import org.springframework.data.solr.core.RequestMethod;
import org.springframework.data.solr.core.ResultHelper;
import org.springframework.data.solr.core.SolrCallback;
import org.springframework.data.solr.core.SolrExceptionTranslator;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.convert.MappingSolrConverter;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.AbstractQueryDecorator;
import org.springframework.data.solr.core.query.FacetAndHighlightQuery;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.data.solr.core.query.result.Cursor;
import org.springframework.data.solr.core.query.result.DelegatingCursor;
import org.springframework.data.solr.core.query.result.FacetAndHighlightPage;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.GroupPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.ScoredPage;
import org.springframework.data.solr.core.query.result.SolrResultPage;
import org.springframework.data.solr.core.query.result.SpellcheckQueryResult;
import org.springframework.data.solr.core.query.result.StatsPage;
import org.springframework.data.solr.core.query.result.TermsPage;
import org.springframework.data.solr.core.query.result.TermsResultPage;
import org.springframework.data.solr.core.schema.DefaultSchemaOperations;
import org.springframework.data.solr.core.schema.SchemaOperations;
import org.springframework.data.solr.core.schema.SolrPersistentEntitySchemaCreator;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.data.solr.server.support.HttpSolrClientFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SolrTemplate
implements SolrOperations,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrTemplate.class);
    private static final PersistenceExceptionTranslator EXCEPTION_TRANSLATOR = new SolrExceptionTranslator();
    private final QueryParsers queryParsers = new QueryParsers();
    @Nullable
    private MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext;
    @Nullable
    private ApplicationContext applicationContext;
    private final RequestMethod defaultRequestMethod;
    @Nullable
    private SolrClientFactory solrClientFactory;
    @Nullable
    private SolrConverter solrConverter;
    private Set<SolrPersistentEntitySchemaCreator.Feature> schemaCreationFeatures = Collections.emptySet();
    private static final List<String> ITERABLE_CLASSES = new ArrayList<String>(){
        {
            this.add(List.class.getName());
            this.add(Collection.class.getName());
            this.add(Iterator.class.getName());
        }
    };

    public SolrTemplate(SolrClient solrClient) {
        this(new HttpSolrClientFactory(solrClient));
    }

    public SolrTemplate(SolrClient solrClient, RequestMethod requestMethod) {
        this((SolrClientFactory)new HttpSolrClientFactory(solrClient), requestMethod);
    }

    public SolrTemplate(SolrClientFactory solrClientFactory) {
        this(solrClientFactory, (SolrConverter)null);
    }

    public SolrTemplate(SolrClientFactory solrClientFactory, RequestMethod requestMethod) {
        this(solrClientFactory, null, requestMethod);
    }

    public SolrTemplate(SolrClientFactory solrClientFactory, @Nullable SolrConverter solrConverter) {
        this(solrClientFactory, solrConverter, RequestMethod.GET);
    }

    public SolrTemplate(SolrClientFactory solrClientFactory, @Nullable SolrConverter solrConverter, @Nullable RequestMethod defaultRequestMethod) {
        Assert.notNull((Object)solrClientFactory, (String)"SolrClientFactory must not be 'null'.");
        this.solrClientFactory = solrClientFactory;
        this.defaultRequestMethod = defaultRequestMethod != null ? defaultRequestMethod : RequestMethod.GET;
        this.solrConverter = solrConverter;
    }

    @Override
    public <T> T execute(SolrCallback<T> action) {
        Assert.notNull(action, (String)"SolrCallback must not be null!");
        try {
            SolrClient solrClient = this.getSolrClient();
            return action.doInSolr(solrClient);
        }
        catch (Exception e) {
            DataAccessException resolved = SolrTemplate.getExceptionTranslator().translateExceptionIfPossible(e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e.getMessage(), e));
            throw resolved == null ? new UncategorizedSolrException(e.getMessage(), e) : resolved;
        }
    }

    @Override
    public SolrPingResponse ping() {
        return this.execute(SolrClient::ping);
    }

    @Override
    public SolrPingResponse ping(String collection) {
        return this.execute(client -> (SolrPingResponse)new SolrPing().process(client, collection));
    }

    @Override
    public long count(String collection, SolrDataQuery query) {
        return this.count(collection, query, this.getDefaultRequestMethod());
    }

    @Override
    public long count(String collection, SolrDataQuery query, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method must not be 'null'.");
        return this.execute(solrClient -> {
            SolrQuery solrQuery = this.constructQuery(query);
            solrQuery.setStart(Integer.valueOf(0));
            solrQuery.setRows(Integer.valueOf(0));
            return solrClient.query(collection, (SolrParams)solrQuery, this.getSolrRequestMethod(method)).getResults().getNumFound();
        });
    }

    @Override
    public UpdateResponse saveBean(String collection, Object obj, Duration commitWithin) {
        this.assertNoCollection(obj);
        return this.execute(solrClient -> solrClient.add(collection, this.convertBeanToSolrInputDocument(obj), this.getCommitWithinTimeout(commitWithin)));
    }

    @Override
    public UpdateResponse saveBeans(String collection, Collection<?> beans, Duration commitWithin) {
        return this.execute(solrClient -> solrClient.add(collection, this.convertBeansToSolrInputDocuments(beans), this.getCommitWithinTimeout(commitWithin)));
    }

    @Override
    public UpdateResponse saveDocument(String collection, SolrInputDocument document, Duration commitWithin) {
        return this.execute(solrClient -> solrClient.add(collection, document, this.getCommitWithinTimeout(commitWithin)));
    }

    @Override
    public UpdateResponse saveDocuments(String collection, Collection<SolrInputDocument> documents, Duration commitWithin) {
        return this.execute(solrClient -> solrClient.add(collection, documents, this.getCommitWithinTimeout(commitWithin)));
    }

    @Override
    public UpdateResponse delete(String collection, SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        String queryString = this.queryParsers.getForClass(query.getClass()).getQueryString(query);
        return this.execute(solrClient -> solrClient.deleteByQuery(collection, queryString));
    }

    @Override
    public UpdateResponse deleteByIds(String collection, String id) {
        Assert.notNull((Object)id, (String)"Cannot delete 'null' id.");
        return this.execute(solrClient -> solrClient.deleteById(collection, id));
    }

    @Override
    public UpdateResponse deleteByIds(String collection, Collection<String> ids) {
        Assert.notNull(ids, (String)"Cannot delete 'null' collection.");
        return this.execute(solrClient -> solrClient.deleteById(collection, ids.stream().collect(Collectors.toList())));
    }

    @Override
    public <T> Optional<T> queryForObject(String collection, Query query, Class<T> clazz) {
        return this.queryForObject(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> Optional<T> queryForObject(String collection, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        query.setPageRequest((Pageable)PageRequest.of((int)0, (int)1));
        QueryResponse response = this.querySolr(collection, query, clazz, method);
        if (response.getResults().size() > 0) {
            if (response.getResults().size() > 1) {
                LOGGER.warn("More than 1 result found for singe result query ('{}'), returning first entry in list", (Object)query);
            }
            return Optional.ofNullable(this.convertSolrDocumentListToBeans(response.getResults(), clazz).get(0));
        }
        return Optional.empty();
    }

    private <T> SolrResultPage<T> doQueryForPage(String collection, Query query, Class<T> clazz, @Nullable RequestMethod requestMethod) {
        QueryResponse response = null;
        QueryParserBase.NamedObjectsQuery namedObjectsQuery = new QueryParserBase.NamedObjectsQuery(query);
        response = this.querySolr(collection, namedObjectsQuery, clazz, requestMethod != null ? requestMethod : this.getDefaultRequestMethod());
        Map<String, Object> objectsName = namedObjectsQuery.getNamesAssociation();
        return this.createSolrResultPage(query, clazz, response, objectsName);
    }

    @Override
    public <T> ScoredPage<T> queryForPage(String collection, Query query, Class<T> clazz) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        return this.doQueryForPage(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T, S extends Page<T>> S query(String collection, Query query, Class<T> clazz) {
        return this.query(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T, S extends Page<T>> S query(String collection, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull(clazz, (String)"Method must not be 'null'.");
        return (S)this.doQueryForPage(collection, query, clazz, method);
    }

    @Override
    public <T> ScoredPage<T> queryForPage(String collection, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method class must not be 'null'.");
        return this.doQueryForPage(collection, query, clazz, method);
    }

    @Override
    public <T> GroupPage<T> queryForGroupPage(String collection, Query query, Class<T> clazz) {
        return this.queryForGroupPage(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> GroupPage<T> queryForGroupPage(String collection, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method class must not be 'null'.");
        return this.doQueryForPage(collection, query, clazz, method);
    }

    @Override
    public <T> StatsPage<T> queryForStatsPage(String collection, Query query, Class<T> clazz) {
        return this.queryForStatsPage(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> StatsPage<T> queryForStatsPage(String collection, Query query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        Assert.notNull((Object)((Object)method), (String)"Method class must not be 'null'.");
        return this.doQueryForPage(collection, query, clazz, method);
    }

    @Override
    public <T> FacetPage<T> queryForFacetPage(String collection, FacetQuery query, Class<T> clazz) {
        return this.queryForFacetPage(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> FacetPage<T> queryForFacetPage(String collection, FacetQuery query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryParserBase.NamedObjectsFacetQuery namedObjectsQuery = new QueryParserBase.NamedObjectsFacetQuery(query);
        return this.createSolrResultPage(query, clazz, this.querySolr(collection, namedObjectsQuery, clazz, method), namedObjectsQuery.getNamesAssociation());
    }

    @Override
    public <T> HighlightPage<T> queryForHighlightPage(String collection, HighlightQuery query, Class<T> clazz) {
        return this.queryForHighlightPage(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> HighlightPage<T> queryForHighlightPage(String collection, HighlightQuery query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryParserBase.NamedObjectsHighlightQuery namedObjectsQuery = new QueryParserBase.NamedObjectsHighlightQuery(query);
        QueryResponse response = this.querySolr(collection, namedObjectsQuery, clazz, method);
        return this.createSolrResultPage(query, clazz, response, namedObjectsQuery.getNamesAssociation());
    }

    @Override
    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String collection, FacetAndHighlightQuery query, Class<T> clazz) {
        return this.queryForFacetAndHighlightPage(collection, query, clazz, this.getDefaultRequestMethod());
    }

    @Override
    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String collection, FacetAndHighlightQuery query, Class<T> clazz, RequestMethod method) {
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        Assert.notNull(clazz, (String)"Target class must not be 'null'.");
        QueryParserBase.NamedObjectsFacetAndHighlightQuery namedObjectsFacetAndHighlightQuery = new QueryParserBase.NamedObjectsFacetAndHighlightQuery(query);
        QueryResponse response = this.querySolr(collection, namedObjectsFacetAndHighlightQuery, clazz, method);
        Map<String, Object> objectsName = namedObjectsFacetAndHighlightQuery.getNamesAssociation();
        return this.createSolrResultPage(query, clazz, response, objectsName);
    }

    private <T> SolrResultPage<T> createSolrResultPage(Query query, Class<T> clazz, QueryResponse response, Map<String, Object> objectsName) {
        List<T> beans = this.convertQueryResponseToBeans(response, clazz);
        SolrDocumentList results = response.getResults();
        long numFound = results == null ? 0L : results.getNumFound();
        Float maxScore = results == null ? null : results.getMaxScore();
        Pageable pageRequest = query.getPageRequest();
        SolrResultPage<T> page = new SolrResultPage<T>(beans, pageRequest, numFound, maxScore);
        page.setFieldStatsResults(ResultHelper.convertFieldStatsInfoToFieldStatsResultMap(response.getFieldStatsInfo()));
        page.setGroupResults(ResultHelper.convertGroupQueryResponseToGroupResultMap(query, objectsName, response, this, clazz));
        if (query instanceof HighlightQuery) {
            ResultHelper.convertAndAddHighlightQueryResponseToResultPage(response, page);
        }
        if (query instanceof FacetQuery) {
            page.setFacetQueryResultPage(ResultHelper.convertFacetQueryResponseToFacetQueryResult((FacetQuery)query, response));
            page.addAllFacetFieldResultPages(ResultHelper.convertFacetQueryResponseToFacetPageMap((FacetQuery)query, response));
            page.addAllFacetPivotFieldResult(ResultHelper.convertFacetQueryResponseToFacetPivotMap((FacetQuery)query, response));
            page.addAllRangeFacetFieldResultPages(ResultHelper.convertFacetQueryResponseToRangeFacetPageMap((FacetQuery)query, response));
        }
        if (query.getSpellcheckOptions() != null) {
            Map<String, List<SpellcheckQueryResult.Alternative>> suggestions = ResultHelper.extreactSuggestions(response);
            for (Map.Entry<String, List<SpellcheckQueryResult.Alternative>> entry : suggestions.entrySet()) {
                page.addSuggestions(entry.getKey(), entry.getValue());
            }
        }
        return page;
    }

    @Override
    public TermsPage queryForTermsPage(String collection, TermsQuery query) {
        return this.queryForTermsPage(collection, query, this.getDefaultRequestMethod());
    }

    @Override
    public TermsPage queryForTermsPage(String collection, TermsQuery query, RequestMethod method) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be 'null'.");
        QueryResponse response = this.querySolr(collection, query, null, method);
        TermsResultPage page = new TermsResultPage();
        page.addAllTerms(ResultHelper.convertTermsQueryResponseToTermsMap(response));
        return page;
    }

    final QueryResponse querySolr(String collection, SolrDataQuery query, @Nullable Class<?> clazz, @Nullable RequestMethod requestMethod) {
        SolrPersistentEntity persistedEntity;
        Assert.notNull((Object)query, (String)"Query must not be 'null'");
        SolrQuery solrQuery = this.constructQuery(query);
        if (clazz != null && (persistedEntity = (SolrPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz)).hasScoreProperty()) {
            solrQuery.setIncludeScore(true);
        }
        LOGGER.debug("Executing query '{}' against solr.", (Object)solrQuery);
        return this.executeSolrQuery(collection, solrQuery, this.getSolrRequestMethod(requestMethod));
    }

    final QueryResponse executeSolrQuery(SolrQuery solrQuery, SolrRequest.METHOD method) {
        return this.executeSolrQuery(null, solrQuery, method);
    }

    final QueryResponse executeSolrQuery(String collection, SolrQuery solrQuery, SolrRequest.METHOD method) {
        return this.execute(solrServer -> solrServer.query(collection, (SolrParams)solrQuery, method));
    }

    protected SolrQuery constructQuery(SolrDataQuery query) {
        return this.lookupQueryParser(query).constructSolrQuery(query);
    }

    private QueryParser lookupQueryParser(SolrDataQuery query) {
        if (query instanceof AbstractQueryDecorator) {
            return this.queryParsers.getForClass(((AbstractQueryDecorator)query).getQueryType());
        }
        return this.queryParsers.getForClass(query.getClass());
    }

    @Override
    public void commit(String collection) {
        this.execute(solrClient -> solrClient.commit(collection));
    }

    @Override
    public void softCommit(String collection) {
        this.execute(solrClient -> solrClient.commit(collection, true, true, true));
    }

    @Override
    public void rollback(String collection) {
        this.execute(solrClient -> solrClient.rollback(collection));
    }

    @Override
    public SolrInputDocument convertBeanToSolrInputDocument(Object bean) {
        if (bean instanceof SolrInputDocument) {
            return (SolrInputDocument)bean;
        }
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        this.getConverter().write(bean, document);
        return document;
    }

    public String getSchemaName(String collectionName) {
        return this.getSchemaOperations(collectionName).getSchemaName();
    }

    @Override
    public <T> Cursor<T> queryForCursor(final String collection, Query query, final Class<T> clazz) {
        return new DelegatingCursor<T>(this.constructQuery(query)){

            @Override
            protected DelegatingCursor.PartialResult<T> doLoad(SolrQuery nativeQuery) {
                QueryResponse response = SolrTemplate.this.executeSolrQuery(collection, nativeQuery, SolrTemplate.this.getSolrRequestMethod(SolrTemplate.this.getDefaultRequestMethod()));
                if (response == null) {
                    return new DelegatingCursor.PartialResult("", Collections.emptyList());
                }
                return new DelegatingCursor.PartialResult(response.getNextCursorMark(), SolrTemplate.this.convertQueryResponseToBeans(response, clazz));
            }
        }.open();
    }

    @Override
    public <T> Collection<T> getByIds(String collection, Collection<?> ids, Class<T> clazz) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.execute(solrClient -> this.convertSolrDocumentListToBeans(solrClient.getById(collection, (Collection)ids.stream().map(Object::toString).collect(Collectors.toList())), clazz));
    }

    @Override
    public <T> Optional<T> getById(String collection, Object id, Class<T> clazz) {
        Assert.notNull((Object)collection, (String)"Collection must not be null!");
        Assert.notNull((Object)id, (String)"Id must not be 'null'.");
        Collection<T> result = this.getByIds(collection, Collections.singletonList(id), clazz);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result.iterator().next());
    }

    @Override
    public SchemaOperations getSchemaOperations(String collection) {
        return new DefaultSchemaOperations(collection, this);
    }

    private Collection<SolrInputDocument> convertBeansToSolrInputDocuments(Iterable<?> beans) {
        if (beans == null) {
            return Collections.emptyList();
        }
        ArrayList<SolrInputDocument> resultList = new ArrayList<SolrInputDocument>();
        for (Object bean : beans) {
            resultList.add(this.convertBeanToSolrInputDocument(bean));
        }
        return resultList;
    }

    public <T> List<T> convertQueryResponseToBeans(QueryResponse response, Class<T> targetClass) {
        return response != null ? this.convertSolrDocumentListToBeans(response.getResults(), targetClass) : Collections.emptyList();
    }

    public <T> List<T> convertSolrDocumentListToBeans(SolrDocumentList documents, Class<T> targetClass) {
        if (documents == null) {
            return Collections.emptyList();
        }
        return this.getConverter().read(documents, targetClass);
    }

    public <T> T convertSolrDocumentToBean(SolrDocument document, Class<T> targetClass) {
        return (T)this.getConverter().read(targetClass, document);
    }

    protected void assertNoCollection(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Collections are not supported for this operation");
        }
    }

    private SolrConverter getDefaultSolrConverter() {
        MappingSolrConverter converter = new MappingSolrConverter(this.mappingContext);
        converter.afterPropertiesSet();
        return converter;
    }

    @Override
    public final SolrClient getSolrClient() {
        return this.solrClientFactory.getSolrClient();
    }

    @Override
    public SolrConverter getConverter() {
        return this.solrConverter;
    }

    public static PersistenceExceptionTranslator getExceptionTranslator() {
        return EXCEPTION_TRANSLATOR;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void registerQueryParser(Class<? extends SolrDataQuery> clazz, QueryParser queryParser) {
        this.queryParsers.registerParser(clazz, queryParser);
    }

    public void setSolrConverter(SolrConverter solrConverter) {
        this.solrConverter = solrConverter;
    }

    public void afterPropertiesSet() {
        if (this.mappingContext == null) {
            this.mappingContext = new SimpleSolrMappingContext(new SolrPersistentEntitySchemaCreator(this.solrClientFactory).enable(this.schemaCreationFeatures));
        }
        if (this.solrConverter == null) {
            this.solrConverter = this.getDefaultSolrConverter();
        }
        this.registerPersistenceExceptionTranslator();
    }

    private void registerPersistenceExceptionTranslator() {
        if (this.applicationContext != null && this.applicationContext.getBeansOfType(PersistenceExceptionTranslator.class).isEmpty() && this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().registerSingleton("solrExceptionTranslator", (Object)EXCEPTION_TRANSLATOR);
        }
    }

    private SolrRequest.METHOD getSolrRequestMethod(@Nullable RequestMethod requestMethod) {
        RequestMethod rm = requestMethod != null ? requestMethod : this.getDefaultRequestMethod();
        switch (rm) {
            case GET: {
                return SolrRequest.METHOD.GET;
            }
            case POST: {
                return SolrRequest.METHOD.POST;
            }
            case PUT: {
                return SolrRequest.METHOD.PUT;
            }
        }
        throw new IllegalArgumentException("Unsupported request method type");
    }

    private int getCommitWithinTimeout(Duration duration) {
        if (duration == null || duration.isZero() || duration.isNegative()) {
            return -1;
        }
        if (duration.toMillis() > Integer.MAX_VALUE) {
            throw new InvalidDataAccessApiUsageException(String.format("CommitWithin must must not exceed int range but was %s", duration.toMillis()));
        }
        return (int)duration.toMillis();
    }

    public void setMappingContext(MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public void setSchemaCreationFeatures(Collection<SolrPersistentEntitySchemaCreator.Feature> schemaCreationFeatures) {
        this.schemaCreationFeatures = new HashSet<SolrPersistentEntitySchemaCreator.Feature>(schemaCreationFeatures);
    }

    public Set<SolrPersistentEntitySchemaCreator.Feature> getSchemaCreationFeatures() {
        if (CollectionUtils.isEmpty(this.schemaCreationFeatures)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.schemaCreationFeatures);
    }

    public RequestMethod getDefaultRequestMethod() {
        return this.defaultRequestMethod;
    }
}

