/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.invoke;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.repository.support.Methods;

public class RepositoryMethod {
    private Method method;
    private Class<?>[] paramTypes;
    private String[] paramNames;
    private boolean pageable = false;
    private boolean sortable = false;

    public RepositoryMethod(Method method) {
        this.method = method;
        for (Class<?> type : this.paramTypes = method.getParameterTypes()) {
            if (Pageable.class.isAssignableFrom(type)) {
                this.pageable = true;
            }
            if (!Sort.class.isAssignableFrom(type)) continue;
            this.sortable = true;
        }
        this.paramNames = Methods.NAME_DISCOVERER.getParameterNames(method);
        if (null == this.paramNames) {
            this.paramNames = new String[this.paramTypes.length];
        }
        Annotation[][] paramAnnos = method.getParameterAnnotations();
        for (int i = 0; i < paramAnnos.length; ++i) {
            if (paramAnnos[i].length > 0) {
                for (Annotation anno : paramAnnos[i]) {
                    if (!Param.class.isAssignableFrom(anno.getClass())) continue;
                    Param p = (Param)anno;
                    this.paramNames[i] = p.value();
                    break;
                }
            }
            if (null != this.paramNames[i]) continue;
            this.paramNames[i] = "arg" + i;
        }
    }

    public Class<?>[] paramTypes() {
        return this.paramTypes;
    }

    public String[] paramNames() {
        return this.paramNames;
    }

    public Method method() {
        return this.method;
    }

    public boolean pageable() {
        return this.pageable;
    }

    public boolean sortable() {
        return this.sortable;
    }
}

