/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.context;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.rest.repository.EntityMetadata;
import org.springframework.data.rest.repository.RepositoryConstraintViolationException;
import org.springframework.data.rest.repository.ValidationErrors;
import org.springframework.data.rest.repository.context.AbstractRepositoryEventListener;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class ValidatingRepositoryEventListener
extends AbstractRepositoryEventListener<ValidatingRepositoryEventListener>
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingRepositoryEventListener.class);
    private Multimap<String, Validator> validators = ArrayListMultimap.create();

    public void afterPropertiesSet() throws Exception {
        if (this.validators.size() == 0) {
            for (Map.Entry entry : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, Validator.class).entrySet()) {
                String name = null;
                Validator v = (Validator)entry.getValue();
                if (((String)entry.getKey()).contains("Save")) {
                    name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("Save") + 4);
                } else if (((String)entry.getKey()).contains("Delete")) {
                    name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("Delete") + 6);
                }
                if (null == name) continue;
                this.validators.put((Object)name, (Object)v);
            }
        }
    }

    public Map<String, Collection<Validator>> getValidators() {
        return this.validators.asMap();
    }

    public ValidatingRepositoryEventListener setValidators(Map<String, Collection<Validator>> validators) {
        for (Map.Entry<String, Collection<Validator>> entry : validators.entrySet()) {
            this.validators.replaceValues((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        return this;
    }

    public ValidatingRepositoryEventListener addValidator(String event, Validator validator) {
        this.validators.put((Object)event, (Object)validator);
        return this;
    }

    @Override
    protected void onBeforeSave(Object entity) {
        this.validate("beforeSave", entity);
    }

    @Override
    protected void onAfterSave(Object entity) {
        this.validate("afterSave", entity);
    }

    @Override
    protected void onBeforeLinkSave(Object parent, Object linked) {
        this.validate("beforeLinkSave", parent);
    }

    @Override
    protected void onAfterLinkSave(Object parent, Object linked) {
        this.validate("afterLinkSave", parent);
    }

    @Override
    protected void onBeforeDelete(Object entity) {
        this.validate("beforeDelete", entity);
    }

    @Override
    protected void onAfterDelete(Object entity) {
        this.validate("afterDelete", entity);
    }

    private Errors validate(String event, Object o) {
        ValidationErrors errors = null;
        if (null != o) {
            Class<?> domainType = o.getClass();
            errors = new ValidationErrors(domainType.getSimpleName(), o, (EntityMetadata)this.repositoryMetadataFor(domainType).entityMetadata());
            Collection validators = this.validators.get((Object)event);
            if (null != validators) {
                for (Validator v : validators) {
                    if (!v.supports(o.getClass())) continue;
                    LOG.debug(event + ": " + o + " with " + v);
                    ValidationUtils.invokeValidator((Validator)v, (Object)o, (Errors)errors);
                }
            }
            if (errors.getErrorCount() > 0) {
                throw new RepositoryConstraintViolationException((Errors)errors);
            }
        }
        return errors;
    }
}

