/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.repository.AttributeMetadata;
import org.springframework.data.rest.repository.EntityMetadata;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.data.rest.repository.annotation.RestResource;
import org.springframework.util.StringUtils;

public abstract class RepositoryExporter<R extends RepositoryExporter<? super R, M, E>, M extends RepositoryMetadata<E>, E extends EntityMetadata<? extends AttributeMetadata>>
implements ApplicationContextAware,
InitializingBean {
    protected ApplicationContext applicationContext;
    protected Repositories repositories;
    protected Map<String, M> repositoryMetadata;
    protected List<String> exportOnlyTheseClasses = Collections.emptyList();
    protected Map<Class<?>, Class<?>> domainTypeMappings = new HashMap();

    public List<String> getExportOnlyTheseClasses() {
        return this.exportOnlyTheseClasses;
    }

    public R setExportOnlyTheseClasses(List<String> exportOnlyTheseClasses) {
        this.exportOnlyTheseClasses = exportOnlyTheseClasses;
        return (R)this;
    }

    public Map<Class<?>, Class<?>> getDomainTypeMappings() {
        return this.domainTypeMappings;
    }

    public R setDomainTypeMappings(Map<Class<?>, Class<?>> domainTypeMappings) {
        this.domainTypeMappings = domainTypeMappings;
        return (R)this;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public Set<String> repositoryNames() {
        this.refresh();
        return this.repositoryMetadata.keySet();
    }

    public boolean hasRepositoryFor(Class<?> domainType) {
        this.refresh();
        for (RepositoryMetadata repoMeta : this.repositoryMetadata.values()) {
            if (!repoMeta.domainType().isAssignableFrom(domainType)) continue;
            return true;
        }
        return false;
    }

    public M repositoryMetadataFor(Class<?> domainType) {
        this.refresh();
        for (RepositoryMetadata repoMeta : this.repositoryMetadata.values()) {
            if (repoMeta.domainType() != domainType) continue;
            return (M)repoMeta;
        }
        Class<?> repoClass = this.domainTypeMappings.get(domainType);
        if (null != repoClass) {
            for (RepositoryMetadata repoMeta : this.repositoryMetadata.values()) {
                if (repoMeta.repositoryClass() != repoClass) continue;
                return (M)repoMeta;
            }
        }
        for (RepositoryMetadata repoMeta : this.repositoryMetadata.values()) {
            if (!repoMeta.domainType().isAssignableFrom(domainType)) continue;
            return (M)repoMeta;
        }
        return null;
    }

    public M repositoryMetadataFor(String name) {
        this.refresh();
        return (M)((RepositoryMetadata)this.repositoryMetadata.get(name));
    }

    protected abstract M createRepositoryMetadata(String var1, Class<?> var2, Class<?> var3, Repositories var4);

    public void refresh() {
        if (null != this.repositories) {
            return;
        }
        this.repositories = new Repositories((ListableBeanFactory)this.applicationContext);
        this.repositoryMetadata = new HashMap<String, M>();
        for (Class domainType : this.repositories) {
            if (!this.exportOnlyTheseClasses.isEmpty() && !this.exportOnlyTheseClasses.contains(domainType.getName())) continue;
            Class repoClass = this.repositories.getRepositoryInformationFor(domainType).getRepositoryInterface();
            String name = StringUtils.uncapitalize((String)repoClass.getSimpleName().replaceAll("Repository", ""));
            RestResource resourceAnno = repoClass.getAnnotation(RestResource.class);
            boolean exported = true;
            if (null != resourceAnno) {
                if (StringUtils.hasText((String)resourceAnno.path())) {
                    name = resourceAnno.path();
                }
                exported = resourceAnno.exported();
            }
            if (!exported) continue;
            this.repositoryMetadata.put(name, this.createRepositoryMetadata(name, domainType, repoClass, this.repositories));
        }
    }
}

