/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.halbrowser;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponents;

@BasePathAwareController
class HalBrowser {
    private static final Logger LOG = LoggerFactory.getLogger(HalBrowser.class);
    static final String BROWSER = "/browser";
    static final String INDEX = "/index.html";

    HalBrowser() {
        LOG.warn("---");
        LOG.warn("Spring Data REST HAL Browser is deprecated! Prefer the HAL Explorer (artifactId: spring-data-rest-hal-explorer)!");
        LOG.warn("---");
    }

    @GetMapping(path={"/", ""}, produces={"text/html"})
    View index(HttpServletRequest request) {
        return this.getRedirectView(request, false);
    }

    @GetMapping(path={"/browser"})
    View browser(HttpServletRequest request) {
        return this.getRedirectView(request, request.getRequestURI().endsWith(BROWSER));
    }

    private View getRedirectView(HttpServletRequest request, boolean browserRelative) {
        String path;
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request);
        UriComponents components = builder.build();
        String string = path = components.getPath() == null ? "" : components.getPath();
        if (!browserRelative) {
            builder.path(BROWSER);
        }
        builder.path(INDEX);
        builder.fragment(browserRelative ? path.substring(0, path.lastIndexOf(BROWSER)) : path);
        return new RedirectView(builder.build().toUriString());
    }
}

