/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.relational.core.mapping.DerivedSqlIdentifier;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.SqlIdentifierExpressionEvaluator;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

class BasicRelationalPersistentEntity<T>
extends BasicPersistentEntity<T, RelationalPersistentProperty>
implements RelationalPersistentEntity<T> {
    private static final ValueExpressionParser PARSER = ValueExpressionParser.create();
    private final Lazy<SqlIdentifier> tableName;
    private final @Nullable ValueExpression tableNameExpression;
    private final Lazy<Optional<SqlIdentifier>> schemaName;
    private final @Nullable ValueExpression schemaNameExpression;
    private final SqlIdentifierExpressionEvaluator sqlIdentifierExpressionEvaluator;
    private boolean forceQuote = true;

    BasicRelationalPersistentEntity(TypeInformation<T> information, NamingStrategy namingStrategy, SqlIdentifierExpressionEvaluator sqlIdentifierExpressionEvaluator) {
        super(information);
        this.sqlIdentifierExpressionEvaluator = sqlIdentifierExpressionEvaluator;
        Lazy defaultSchema = Lazy.of(() -> StringUtils.hasText((String)namingStrategy.getSchema()) ? Optional.of(this.createDerivedSqlIdentifier(namingStrategy.getSchema())) : Optional.empty());
        if (this.isAnnotationPresent(Table.class)) {
            Table table = (Table)this.getRequiredAnnotation(Table.class);
            this.tableName = Lazy.of(() -> StringUtils.hasText((String)table.value()) ? this.createSqlIdentifier(table.value()) : this.createDerivedSqlIdentifier(namingStrategy.getTableName(this.getType())));
            this.tableNameExpression = BasicRelationalPersistentEntity.detectExpression(table.value());
            this.schemaName = StringUtils.hasText((String)table.schema()) ? Lazy.of(() -> Optional.of(this.createSqlIdentifier(table.schema()))) : defaultSchema;
            this.schemaNameExpression = BasicRelationalPersistentEntity.detectExpression(table.schema());
        } else {
            this.tableName = Lazy.of(() -> this.createDerivedSqlIdentifier(namingStrategy.getTableName(this.getType())));
            this.tableNameExpression = null;
            this.schemaName = defaultSchema;
            this.schemaNameExpression = null;
        }
    }

    private static @Nullable ValueExpression detectExpression(@Nullable String potentialExpression) {
        if (!StringUtils.hasText((String)potentialExpression)) {
            return null;
        }
        ValueExpression expression = PARSER.parse(potentialExpression);
        return expression.isLiteral() ? null : expression;
    }

    private SqlIdentifier createSqlIdentifier(String name) {
        return this.isForceQuote() ? SqlIdentifier.quoted(name) : SqlIdentifier.unquoted(name);
    }

    private SqlIdentifier createDerivedSqlIdentifier(String name) {
        return new DerivedSqlIdentifier(name, this.isForceQuote());
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    @Override
    public SqlIdentifier getTableName() {
        if (this.tableNameExpression == null) {
            return (SqlIdentifier)this.tableName.get();
        }
        return this.sqlIdentifierExpressionEvaluator.evaluate(this.tableNameExpression, this.isForceQuote());
    }

    @Override
    public SqlIdentifier getQualifiedTableName() {
        SqlIdentifier schema = this.schemaNameExpression != null ? this.sqlIdentifierExpressionEvaluator.evaluate(this.schemaNameExpression, this.isForceQuote()) : (SqlIdentifier)((Optional)this.schemaName.get()).orElse(null);
        if (schema == null) {
            return this.getTableName();
        }
        if (this.schemaNameExpression != null) {
            schema = this.sqlIdentifierExpressionEvaluator.evaluate(this.schemaNameExpression, this.isForceQuote());
        }
        return SqlIdentifier.from(schema, this.getTableName());
    }

    @Override
    @Deprecated(forRemoval=true)
    public SqlIdentifier getIdColumn() {
        return ((RelationalPersistentProperty)this.getRequiredIdProperty()).getColumnName();
    }

    public String toString() {
        return String.format("BasicRelationalPersistentEntity<%s>", this.getType());
    }
}

