/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.TupleExpression;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.TypedSingleConditionRenderSupport;

class TupleVisitor
extends TypedSingleConditionRenderSupport<TupleExpression>
implements PartRenderer {
    private final StringBuilder part = new StringBuilder();
    private boolean needsComma = false;

    TupleVisitor(RenderContext context) {
        super(context);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.hasDelegatedRendering()) {
            if (this.needsComma) {
                this.part.append(", ");
            }
            this.part.append(this.consumeRenderedPart());
            this.needsComma = true;
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(TupleExpression segment) {
        this.part.append("(");
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(TupleExpression segment) {
        this.part.append(")");
        return super.leaveMatched(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.part;
    }
}

