/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import org.springframework.core.env.Environment;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.relational.core.mapping.EmbeddedContext;
import org.springframework.data.relational.core.mapping.EmbeddedRelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

class EmbeddedRelationalPersistentEntity<T>
implements RelationalPersistentEntity<T> {
    private final RelationalPersistentEntity<T> delegate;
    private final EmbeddedContext context;

    public EmbeddedRelationalPersistentEntity(RelationalPersistentEntity<T> delegate, EmbeddedContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    @Override
    public SqlIdentifier getTableName() {
        throw new MappingException("Cannot map embedded entity to table");
    }

    @Override
    public SqlIdentifier getIdColumn() {
        throw new MappingException("Embedded entity does not have an id column");
    }

    public void addPersistentProperty(RelationalPersistentProperty property) {
        throw new UnsupportedOperationException();
    }

    public void addAssociation(Association<RelationalPersistentProperty> association) {
        throw new UnsupportedOperationException();
    }

    public void verify() throws MappingException {
    }

    public Iterator<RelationalPersistentProperty> iterator() {
        final Iterator iterator = this.delegate.iterator();
        return new Iterator<RelationalPersistentProperty>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public RelationalPersistentProperty next() {
                return EmbeddedRelationalPersistentEntity.this.wrap((RelationalPersistentProperty)iterator.next());
            }
        };
    }

    public void setPersistentPropertyAccessorFactory(PersistentPropertyAccessorFactory factory) {
        this.delegate.setPersistentPropertyAccessorFactory(factory);
    }

    public void setEnvironment(Environment environment) {
        this.delegate.setEnvironment(environment);
    }

    public void setEvaluationContextProvider(EvaluationContextProvider provider) {
        this.delegate.setEvaluationContextProvider(provider);
    }

    public String getName() {
        return this.delegate.getName();
    }

    @Nullable
    public InstanceCreatorMetadata<RelationalPersistentProperty> getInstanceCreatorMetadata() {
        return this.delegate.getInstanceCreatorMetadata();
    }

    public boolean isCreatorArgument(PersistentProperty<?> property) {
        return this.delegate.isCreatorArgument(property);
    }

    public boolean isIdProperty(PersistentProperty<?> property) {
        return this.delegate.isIdProperty(property);
    }

    public boolean isVersionProperty(PersistentProperty<?> property) {
        return this.delegate.isVersionProperty(property);
    }

    @Nullable
    public RelationalPersistentProperty getIdProperty() {
        return this.wrap((RelationalPersistentProperty)this.delegate.getIdProperty());
    }

    @Nullable
    public RelationalPersistentProperty getVersionProperty() {
        return this.wrap((RelationalPersistentProperty)this.delegate.getVersionProperty());
    }

    @Nullable
    public RelationalPersistentProperty getPersistentProperty(String name) {
        return this.wrap((RelationalPersistentProperty)this.delegate.getPersistentProperty(name));
    }

    public Iterable<RelationalPersistentProperty> getPersistentProperties(Class<? extends Annotation> annotationType) {
        return Streamable.of((Iterable)this.delegate.getPersistentProperties(annotationType)).map(this::wrap);
    }

    public boolean hasIdProperty() {
        return this.delegate.hasIdProperty();
    }

    public boolean hasVersionProperty() {
        return this.delegate.hasVersionProperty();
    }

    public Class<T> getType() {
        return this.delegate.getType();
    }

    public Alias getTypeAlias() {
        return this.delegate.getTypeAlias();
    }

    public TypeInformation<T> getTypeInformation() {
        return this.delegate.getTypeInformation();
    }

    public void doWithProperties(PropertyHandler<RelationalPersistentProperty> handler) {
        this.delegate.doWithProperties(persistentProperty -> handler.doWithPersistentProperty((PersistentProperty)this.wrap((RelationalPersistentProperty)persistentProperty)));
    }

    public void doWithProperties(SimplePropertyHandler handler) {
        this.delegate.doWithProperties(property -> handler.doWithPersistentProperty((PersistentProperty)this.wrap((RelationalPersistentProperty)property)));
    }

    public void doWithAssociations(AssociationHandler<RelationalPersistentProperty> handler) {
        this.delegate.doWithAssociations(association -> handler.doWithAssociation(new Association((PersistentProperty)this.wrap((RelationalPersistentProperty)association.getInverse()), (PersistentProperty)this.wrap((RelationalPersistentProperty)association.getObverse()))));
    }

    public void doWithAssociations(SimpleAssociationHandler handler) {
        this.delegate.doWithAssociations(association -> handler.doWithAssociation(new Association((PersistentProperty)this.wrap((RelationalPersistentProperty)association.getInverse()), (PersistentProperty)this.wrap((RelationalPersistentProperty)association.getObverse()))));
    }

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return (A)this.delegate.findAnnotation(annotationType);
    }

    public <A extends Annotation> boolean isAnnotationPresent(Class<A> annotationType) {
        return this.delegate.isAnnotationPresent(annotationType);
    }

    public <B> PersistentPropertyAccessor<B> getPropertyAccessor(B bean) {
        return this.delegate.getPropertyAccessor(bean);
    }

    public <B> PersistentPropertyPathAccessor<B> getPropertyPathAccessor(B bean) {
        return this.delegate.getPropertyPathAccessor(bean);
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        return this.delegate.getIdentifierAccessor(bean);
    }

    public boolean isNew(Object bean) {
        return this.delegate.isNew(bean);
    }

    public boolean isImmutable() {
        return this.delegate.isImmutable();
    }

    public boolean requiresPropertyPopulation() {
        return this.delegate.requiresPropertyPopulation();
    }

    @Nullable
    private RelationalPersistentProperty wrap(@Nullable RelationalPersistentProperty source) {
        if (source == null) {
            return null;
        }
        return new EmbeddedRelationalPersistentProperty(source, this.context);
    }

    public String toString() {
        return String.format("EmbeddedRelationalPersistentEntity<%s>", this.getType());
    }
}

