/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.StringJoiner;
import org.springframework.data.relational.core.sql.Cast;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class CastVisitor
extends TypedSubtreeVisitor<Cast>
implements PartRenderer {
    private final RenderContext context;
    @Nullable
    private StringJoiner joiner;
    @Nullable
    private ExpressionVisitor expressionVisitor;

    CastVisitor(RenderContext context) {
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(Cast cast) {
        this.joiner = new StringJoiner(", ", "CAST(", " AS " + cast.getTargetType() + ")");
        return super.enterMatched(cast);
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        this.expressionVisitor = new ExpressionVisitor(this.context, ExpressionVisitor.AliasHandling.IGNORE);
        return DelegatingVisitor.Delegation.delegateTo(this.expressionVisitor);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        Assert.state((this.joiner != null ? 1 : 0) != 0, (String)"Joiner must not be null");
        Assert.state((this.expressionVisitor != null ? 1 : 0) != 0, (String)"ExpressionVisitor must not be null");
        this.joiner.add(this.expressionVisitor.getRenderedPart());
        return super.leaveNested(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        if (this.joiner == null) {
            throw new IllegalStateException("Joiner must not be null");
        }
        return this.joiner.toString();
    }
}

