/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Optional;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.relational.core.mapping.DerivedSqlIdentifier;
import org.springframework.data.relational.core.mapping.ExpressionEvaluator;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class BasicRelationalPersistentEntity<T>
extends BasicPersistentEntity<T, RelationalPersistentProperty>
implements RelationalPersistentEntity<T> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final Lazy<SqlIdentifier> tableName;
    @Nullable
    private final Expression tableNameExpression;
    private final Lazy<Optional<SqlIdentifier>> schemaName;
    @Nullable
    private final Expression schemaNameExpression;
    private final ExpressionEvaluator expressionEvaluator;
    private boolean forceQuote = true;

    BasicRelationalPersistentEntity(TypeInformation<T> information, NamingStrategy namingStrategy, ExpressionEvaluator expressionEvaluator) {
        super(information);
        this.expressionEvaluator = expressionEvaluator;
        Lazy defaultSchema = Lazy.of(() -> StringUtils.hasText((String)namingStrategy.getSchema()) ? Optional.of(this.createDerivedSqlIdentifier(namingStrategy.getSchema())) : Optional.empty());
        if (this.isAnnotationPresent(Table.class)) {
            Table table = (Table)this.getRequiredAnnotation(Table.class);
            this.tableName = Lazy.of(() -> StringUtils.hasText((String)table.value()) ? this.createSqlIdentifier(table.value()) : this.createDerivedSqlIdentifier(namingStrategy.getTableName(this.getType())));
            this.tableNameExpression = BasicRelationalPersistentEntity.detectExpression(table.value());
            this.schemaName = StringUtils.hasText((String)table.schema()) ? Lazy.of(() -> Optional.of(this.createSqlIdentifier(table.schema()))) : defaultSchema;
            this.schemaNameExpression = BasicRelationalPersistentEntity.detectExpression(table.schema());
        } else {
            this.tableName = Lazy.of(() -> this.createDerivedSqlIdentifier(namingStrategy.getTableName(this.getType())));
            this.tableNameExpression = null;
            this.schemaName = defaultSchema;
            this.schemaNameExpression = null;
        }
    }

    @Nullable
    private static Expression detectExpression(@Nullable String potentialExpression) {
        if (!StringUtils.hasText((String)potentialExpression)) {
            return null;
        }
        Expression expression = PARSER.parseExpression(potentialExpression, ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    private SqlIdentifier createSqlIdentifier(String name) {
        return this.isForceQuote() ? SqlIdentifier.quoted(name) : SqlIdentifier.unquoted(name);
    }

    private SqlIdentifier createDerivedSqlIdentifier(String name) {
        return new DerivedSqlIdentifier(name, this.isForceQuote());
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    @Override
    public SqlIdentifier getTableName() {
        if (this.tableNameExpression == null) {
            return (SqlIdentifier)this.tableName.get();
        }
        return this.createSqlIdentifier(this.expressionEvaluator.evaluate(this.tableNameExpression));
    }

    @Override
    public SqlIdentifier getQualifiedTableName() {
        SqlIdentifier schema = this.schemaNameExpression != null ? this.createSqlIdentifier(this.expressionEvaluator.evaluate(this.schemaNameExpression)) : (SqlIdentifier)((Optional)this.schemaName.get()).orElse(null);
        if (schema == null) {
            return this.getTableName();
        }
        if (this.schemaNameExpression != null) {
            schema = this.createSqlIdentifier(this.expressionEvaluator.evaluate(this.schemaNameExpression));
        }
        return SqlIdentifier.from(schema, this.getTableName());
    }

    @Override
    public SqlIdentifier getIdColumn() {
        return ((RelationalPersistentProperty)this.getRequiredIdProperty()).getColumnName();
    }

    public String toString() {
        return String.format("BasicRelationalPersistentEntity<%s>", this.getType());
    }
}

