/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.relational.repository.query.ParameterMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ParameterMetadataProvider
implements Iterable<ParameterMetadata> {
    private static final Object VALUE_PLACEHOLDER = new Object();
    private final Iterator<? extends Parameter> bindableParameterIterator;
    private final Iterator<Object> bindableParameterValueIterator;
    private final List<ParameterMetadata> parameterMetadata = new ArrayList<ParameterMetadata>();

    public ParameterMetadataProvider(RelationalParameterAccessor accessor) {
        this(accessor.getBindableParameters(), accessor.iterator());
    }

    private ParameterMetadataProvider(Parameters<?, ?> parameters, @Nullable Iterator<Object> bindableParameterValueIterator) {
        Assert.notNull(parameters, (String)"Parameters must not be null");
        this.bindableParameterIterator = parameters.getBindableParameters().iterator();
        this.bindableParameterValueIterator = bindableParameterValueIterator;
    }

    @Override
    public Iterator<ParameterMetadata> iterator() {
        return this.parameterMetadata.iterator();
    }

    public ParameterMetadata next(Part part) {
        Assert.isTrue((boolean)this.bindableParameterIterator.hasNext(), () -> String.format("No parameter available for part %s.", part));
        Parameter parameter = this.bindableParameterIterator.next();
        String parameterName = this.getParameterName(parameter, part.getProperty().getSegment());
        Object parameterValue = this.getParameterValue();
        Part.Type partType = part.getType();
        this.checkNullIsAllowed(parameterName, parameterValue, partType);
        Class parameterType = parameter.getType();
        Object preparedParameterValue = this.prepareParameterValue(parameterValue, parameterType, partType);
        ParameterMetadata metadata = new ParameterMetadata(parameterName, preparedParameterValue, parameterType);
        this.parameterMetadata.add(metadata);
        return metadata;
    }

    private String getParameterName(Parameter parameter, String defaultName) {
        if (parameter.isExplicitlyNamed()) {
            return (String)parameter.getName().orElseThrow(() -> new IllegalArgumentException("Parameter needs to be named"));
        }
        return defaultName;
    }

    @Nullable
    private Object getParameterValue() {
        return this.bindableParameterValueIterator == null ? VALUE_PLACEHOLDER : this.bindableParameterValueIterator.next();
    }

    private void checkNullIsAllowed(String parameterName, @Nullable Object parameterValue, Part.Type partType) {
        if (parameterValue == null && !Part.Type.SIMPLE_PROPERTY.equals((Object)partType)) {
            throw new IllegalArgumentException(String.format("Value of parameter with name %s must not be null", parameterName));
        }
    }

    @Nullable
    protected Object prepareParameterValue(@Nullable Object value, Class<?> valueType, Part.Type partType) {
        if (value == null || !CharSequence.class.isAssignableFrom(valueType)) {
            return value;
        }
        switch (partType) {
            case STARTING_WITH: {
                return escaper -> escaper.escape(value.toString()) + "%";
            }
            case ENDING_WITH: {
                return escaper -> "%" + escaper.escape(value.toString());
            }
            case CONTAINING: 
            case NOT_CONTAINING: {
                return escaper -> "%" + escaper.escape(value.toString()) + "%";
            }
        }
        return value;
    }
}

