/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.SegmentList;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.util.Assert;

class SegmentListVisitor
extends TypedSubtreeVisitor<SegmentList<?>>
implements PartRenderer {
    private final StringBuilder part = new StringBuilder();
    private final String start;
    private final String separator;
    private final DelegatingVisitor nestedVisitor;
    private boolean first = true;

    SegmentListVisitor(String start, String separator, DelegatingVisitor nestedVisitor) {
        Assert.notNull((Object)start, (String)"Start must not be null");
        Assert.notNull((Object)separator, (String)"Separator must not be null");
        Assert.notNull((Object)nestedVisitor, (String)"Nested Visitor must not be null");
        Assert.isInstanceOf(PartRenderer.class, (Object)nestedVisitor, (String)"Nested visitor must implement PartRenderer");
        this.start = start;
        this.separator = separator;
        this.nestedVisitor = nestedVisitor;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (this.first) {
            this.part.append(this.start);
            this.first = false;
        } else {
            this.part.append(this.separator);
        }
        return DelegatingVisitor.Delegation.delegateTo(this.nestedVisitor);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        this.part.append(((PartRenderer)((Object)this.nestedVisitor)).getRenderedPart());
        return super.leaveNested(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.part;
    }
}

