/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Optional;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.relational.core.mapping.DerivedSqlIdentifier;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class RelationalPersistentEntityImpl<T>
extends BasicPersistentEntity<T, RelationalPersistentProperty>
implements RelationalPersistentEntity<T> {
    private final NamingStrategy namingStrategy;
    private final Lazy<Optional<SqlIdentifier>> tableName;
    private final Lazy<Optional<SqlIdentifier>> schemaName;
    private boolean forceQuote = true;

    RelationalPersistentEntityImpl(TypeInformation<T> information, NamingStrategy namingStrategy) {
        super(information);
        this.namingStrategy = namingStrategy;
        this.tableName = Lazy.of(() -> Optional.ofNullable((Table)this.findAnnotation(Table.class)).map(Table::value).filter(StringUtils::hasText).map(this::createSqlIdentifier));
        this.schemaName = Lazy.of(() -> Optional.ofNullable((Table)this.findAnnotation(Table.class)).map(Table::schema).filter(StringUtils::hasText).map(this::createSqlIdentifier));
    }

    private SqlIdentifier createSqlIdentifier(String name) {
        return this.isForceQuote() ? SqlIdentifier.quoted(name) : SqlIdentifier.unquoted(name);
    }

    private SqlIdentifier createDerivedSqlIdentifier(String name) {
        return new DerivedSqlIdentifier(name, this.isForceQuote());
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    @Override
    public SqlIdentifier getTableName() {
        SqlIdentifier schema = this.determineCurrentEntitySchema();
        Optional explicitlySpecifiedTableName = (Optional)this.tableName.get();
        SqlIdentifier schemalessTableIdentifier = this.createDerivedSqlIdentifier(this.namingStrategy.getTableName(this.getType()));
        if (schema == null) {
            return explicitlySpecifiedTableName.orElse(schemalessTableIdentifier);
        }
        return explicitlySpecifiedTableName.map(sqlIdentifier -> SqlIdentifier.from(schema, sqlIdentifier)).orElse(SqlIdentifier.from(schema, schemalessTableIdentifier));
    }

    @Nullable
    private SqlIdentifier determineCurrentEntitySchema() {
        Optional explicitlySpecifiedSchema = (Optional)this.schemaName.get();
        return explicitlySpecifiedSchema.orElseGet(() -> StringUtils.hasText((String)this.namingStrategy.getSchema()) ? this.createDerivedSqlIdentifier(this.namingStrategy.getSchema()) : null);
    }

    @Override
    public SqlIdentifier getIdColumn() {
        return ((RelationalPersistentProperty)this.getRequiredIdProperty()).getColumnName();
    }

    public String toString() {
        return String.format("RelationalPersistentEntityImpl<%s>", this.getType());
    }
}

