/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class OrderByClauseVisitor
extends TypedSubtreeVisitor<OrderByField>
implements PartRenderer {
    private final RenderContext context;
    private final StringBuilder builder = new StringBuilder();
    private boolean first = true;

    OrderByClauseVisitor(RenderContext context) {
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(OrderByField segment) {
        if (!this.first) {
            this.builder.append(", ");
        }
        this.first = false;
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(OrderByField segment) {
        OrderByField field = segment;
        if (field.getDirection() != null) {
            this.builder.append(" ").append(field.getDirection());
        }
        return DelegatingVisitor.Delegation.leave();
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof Column) {
            this.builder.append(NameRenderer.reference(this.context, (Column)segment));
        }
        return super.leaveNested(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

