/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.sql.render.NamingStrategies;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;
import org.springframework.util.Assert;

public class RenderContextFactory {
    public final Dialect dialect;
    public RenderNamingStrategy namingStrategy = NamingStrategies.asIs();

    public RenderContextFactory(Dialect dialect) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null!");
        this.dialect = dialect;
    }

    public void setNamingStrategy(RenderNamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"RenderNamingStrategy must not be null");
        this.namingStrategy = namingStrategy;
    }

    public RenderContext createRenderContext() {
        SelectRenderContext select = this.dialect.getSelectContext();
        return new DialectRenderContext(this.namingStrategy, select);
    }

    static class DialectRenderContext
    implements RenderContext {
        private final RenderNamingStrategy renderNamingStrategy;
        private final SelectRenderContext selectRenderContext;

        @Override
        public RenderNamingStrategy getNamingStrategy() {
            return this.renderNamingStrategy;
        }

        @Override
        public SelectRenderContext getSelect() {
            return this.selectRenderContext;
        }

        public DialectRenderContext(RenderNamingStrategy renderNamingStrategy, SelectRenderContext selectRenderContext) {
            this.renderNamingStrategy = renderNamingStrategy;
            this.selectRenderContext = selectRenderContext;
        }
    }
}

