/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyValue;
import io.lettuce.core.LPosArgs;
import io.lettuce.core.api.async.RedisListAsyncCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.util.Assert;

@NullUnmarked
class LettuceListCommands
implements RedisListCommands {
    private final LettuceConnection connection;

    LettuceListCommands(@NonNull LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::rpush, key, values);
    }

    @Override
    public List<Long> lPos(byte @NonNull [] key, byte @NonNull [] element, @Nullable Integer rank, @Nullable Integer count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)element, (String)"Element must not be null");
        LPosArgs args = new LPosArgs();
        if (rank != null) {
            args.rank((long)rank.intValue());
        }
        if (count != null) {
            return (List)this.connection.invoke().just(RedisListAsyncCommands::lpos, key, element, count, args);
        }
        return this.connection.invoke().from(RedisListAsyncCommands::lpos, key, element, args).getOrElse(Collections::singletonList, Collections::emptyList);
    }

    @Override
    public Long lPush(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::lpush, key, values);
    }

    @Override
    public Long rPushX(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Long)this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.rpushx(x$0, (Object[])new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lPushX(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Long)this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.lpushx(x$0, (Object[])new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lLen(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::llen, key);
    }

    @Override
    public List<byte @NonNull []> lRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisListAsyncCommands::lrange, key, start, end);
    }

    @Override
    public void lTrim(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        this.connection.invokeStatus().just(RedisListAsyncCommands::ltrim, key, start, end);
    }

    @Override
    public byte[] lIndex(byte @NonNull [] key, long index) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::lindex, key, index);
    }

    @Override
    public Long lInsert(byte @NonNull [] key, @NonNull RedisListCommands.Position where, byte @NonNull [] pivot, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::linsert, key, LettuceConverters.toBoolean(where), pivot, value);
    }

    @Override
    public byte[] lMove(byte @NonNull [] sourceKey, byte @NonNull [] destinationKey, @NonNull RedisListCommands.Direction from, @NonNull RedisListCommands.Direction to) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)((Object)from), (String)"From direction must not be null");
        Assert.notNull((Object)((Object)to), (String)"To direction must not be null");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::lmove, sourceKey, destinationKey, LettuceConverters.toLmoveArgs(from, to));
    }

    @Override
    public byte[] bLMove(byte @NonNull [] sourceKey, byte @NonNull [] destinationKey, @NonNull RedisListCommands.Direction from, @NonNull RedisListCommands.Direction to, double timeout) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)((Object)from), (String)"From direction must not be null");
        Assert.notNull((Object)((Object)to), (String)"To direction must not be null");
        return (byte[])this.connection.invoke(this.connection.getAsyncDedicatedConnection()).just(RedisListAsyncCommands::blmove, sourceKey, destinationKey, LettuceConverters.toLmoveArgs(from, to), timeout);
    }

    @Override
    public void lSet(byte @NonNull [] key, long index, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.connection.invokeStatus().just(RedisListAsyncCommands::lset, key, index, value);
    }

    @Override
    public Long lRem(byte @NonNull [] key, long count, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Long)this.connection.invoke().just(RedisListAsyncCommands::lrem, key, count, value);
    }

    @Override
    public byte[] lPop(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::lpop, key);
    }

    @Override
    public List<byte @NonNull []> lPop(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisListAsyncCommands::lpop, key, count);
    }

    @Override
    public byte[] rPop(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::rpop, key);
    }

    @Override
    public List<byte @NonNull []> rPop(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisListAsyncCommands::rpop, key, count);
    }

    @Override
    public List<byte @NonNull []> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return (List)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from(RedisListAsyncCommands::blpop, timeout, keys).get(LettuceListCommands::toBytesList);
    }

    @Override
    public List<byte @NonNull []> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return (List)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from(RedisListAsyncCommands::brpop, timeout, keys).get(LettuceListCommands::toBytesList);
    }

    @Override
    public byte[] rPopLPush(byte @NonNull [] srcKey, byte @NonNull [] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        return (byte[])this.connection.invoke().just(RedisListAsyncCommands::rpoplpush, srcKey, dstKey);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte @NonNull [] srcKey, byte @NonNull [] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        return (byte[])this.connection.invoke(this.connection.getAsyncDedicatedConnection()).just(RedisListAsyncCommands::brpoplpush, timeout, srcKey, dstKey);
    }

    private static List<byte[]> toBytesList(KeyValue<byte[], byte[]> source) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(2);
        list.add((byte[])source.getKey());
        list.add((byte[])source.getValue());
        return list;
    }
}

