/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.core.ExpireChanges;
import org.springframework.data.redis.core.ReactiveHashOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.Expirations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveHashOperations<H, HK, HV>
implements ReactiveHashOperations<H, HK, HV> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<H, ?> serializationContext;

    DefaultReactiveHashOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<H, ?> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Long> remove(H key, Object ... hashKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)hashKeys, (String)"Hash keys must not be null");
        Assert.notEmpty((Object[])hashKeys, (String)"Hash keys must not be empty");
        Assert.noNullElements((Object[])hashKeys, (String)"Hash keys must not contain null elements");
        return this.createMono(hashCommands -> Flux.fromArray((Object[])hashKeys).map(hashKey -> hashKey).map(this::rawHashKey).collectList().flatMap(hks -> hashCommands.hDel(this.rawKey(key), (Collection<ByteBuffer>)hks)));
    }

    @Override
    public Mono<Boolean> hasKey(H key, Object hashKey) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)hashKey, (String)"Hash key must not be null");
        return this.createMono(hashCommands -> hashCommands.hExists(this.rawKey(key), this.rawHashKey(hashKey)));
    }

    @Override
    public Mono<HV> get(H key, Object hashKey) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)hashKey, (String)"Hash key must not be null");
        return this.createMono(hashCommands -> hashCommands.hGet(this.rawKey(key), this.rawHashKey(hashKey)).map(this::readHashValue));
    }

    @Override
    public Mono<List<HV>> multiGet(H key, Collection<HK> hashKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(hashKeys, (String)"Hash keys must not be null");
        Assert.notEmpty(hashKeys, (String)"Hash keys must not be empty");
        return this.createMono(hashCommands -> Flux.fromIterable((Iterable)hashKeys).map(this::rawHashKey).collectList().flatMap(hks -> hashCommands.hMGet(this.rawKey(key), (Collection<ByteBuffer>)hks)).map(this::deserializeHashValues));
    }

    @Override
    public Mono<List<HV>> getAndDelete(H key, Collection<HK> hashKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(hashKeys, (String)"Hash keys must not be null");
        Assert.notEmpty(hashKeys, (String)"Hash keys must not be empty");
        return this.createMono(hashCommands -> Flux.fromIterable((Iterable)hashKeys).map(this::rawHashKey).collectList().flatMap(hks -> hashCommands.hGetDel(this.rawKey(key), (Collection<ByteBuffer>)hks)).map(this::deserializeHashValues));
    }

    @Override
    public Mono<Boolean> putAndExpire(H key, Map<? extends HK, ? extends HV> map, RedisHashCommands.HashFieldSetOption condition, Expiration expiration) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(map, (String)"Map must not be null");
        return this.createMono(hashCommands -> Flux.fromIterable(() -> map.entrySet().iterator()).collectMap(entry -> this.rawHashKey(entry.getKey()), entry -> this.rawHashValue(entry.getValue())).flatMap(serialized -> hashCommands.hSetEx(this.rawKey(key), (Map<ByteBuffer, ByteBuffer>)serialized, condition, expiration)));
    }

    @Override
    public Mono<List<HV>> getAndExpire(H key, Expiration expiration, Collection<HK> hashKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(hashKeys, (String)"Hash keys must not be null");
        Assert.notEmpty(hashKeys, (String)"Hash keys must not be empty");
        return this.createMono(hashCommands -> Flux.fromIterable((Iterable)hashKeys).map(this::rawHashKey).collectList().flatMap(hks -> hashCommands.hGetEx(this.rawKey(key), expiration, (List<ByteBuffer>)hks)).map(this::deserializeHashValues));
    }

    @Override
    public Mono<Long> increment(H key, HK hashKey, long delta) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(hashKey, (String)"Hash key must not be null");
        return this.template.doCreateMono(connection -> connection.numberCommands().hIncrBy(this.rawKey(key), this.rawHashKey(hashKey), delta));
    }

    @Override
    public Mono<Double> increment(H key, HK hashKey, double delta) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(hashKey, (String)"Hash key must not be null");
        return this.template.doCreateMono(connection -> connection.numberCommands().hIncrBy(this.rawKey(key), this.rawHashKey(hashKey), delta));
    }

    @Override
    public Mono<HK> randomKey(H key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.template.doCreateMono(connection -> connection.hashCommands().hRandField(this.rawKey(key))).map(this::readRequiredHashKey);
    }

    @Override
    public Mono<Map.Entry<HK, HV>> randomEntry(H key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(hashCommands -> hashCommands.hRandFieldWithValues(this.rawKey(key))).map(this::deserializeHashEntry);
    }

    @Override
    public Flux<HK> randomKeys(H key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.template.doCreateFlux(connection -> connection.hashCommands().hRandField(this.rawKey(key), count)).map(this::readRequiredHashKey);
    }

    @Override
    public Flux<Map.Entry<HK, HV>> randomEntries(H key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.template.doCreateFlux(connection -> connection.hashCommands().hRandFieldWithValues(this.rawKey(key), count)).map(this::deserializeHashEntry);
    }

    @Override
    public Flux<HK> keys(H key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createFlux(connection -> connection.hKeys(this.rawKey(key)).map(this::readRequiredHashKey));
    }

    @Override
    public Mono<Long> size(H key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(hashCommands -> hashCommands.hLen(this.rawKey(key)));
    }

    @Override
    public Mono<Boolean> putAll(H key, Map<? extends HK, ? extends HV> map) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(map, (String)"Map must not be null");
        return this.createMono(hashCommands -> Flux.fromIterable(() -> map.entrySet().iterator()).collectMap(entry -> this.rawHashKey(entry.getKey()), entry -> this.rawHashValue(entry.getValue())).flatMap(serialized -> hashCommands.hMSet(this.rawKey(key), (Map<ByteBuffer, ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Boolean> put(H key, HK hashKey, HV value) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(hashKey, (String)"Hash key must not be null");
        Assert.notNull(value, (String)"Hash value must not be null");
        return this.createMono(hashCommands -> hashCommands.hSet(this.rawKey(key), this.rawHashKey(hashKey), this.rawHashValue(value)));
    }

    @Override
    public Mono<Boolean> putIfAbsent(H key, HK hashKey, HV value) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(hashKey, (String)"Hash key must not be null");
        Assert.notNull(value, (String)"Hash value must not be null");
        return this.createMono(hashCommands -> hashCommands.hSetNX(this.rawKey(key), this.rawHashKey(hashKey), this.rawHashValue(value)));
    }

    @Override
    public Flux<HV> values(H key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createFlux(hashCommands -> hashCommands.hVals(this.rawKey(key)).map(this::readRequiredHashValue));
    }

    @Override
    public Flux<Map.Entry<HK, HV>> entries(H key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createFlux(hashCommands -> hashCommands.hGetAll(this.rawKey(key)).map(this::deserializeHashEntry));
    }

    @Override
    public Flux<Map.Entry<HK, HV>> scan(H key, ScanOptions options) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(key, (String)"ScanOptions must not be null");
        return this.createFlux(hashCommands -> hashCommands.hScan(this.rawKey(key), options).map(this::deserializeHashEntry));
    }

    @Override
    public Mono<ExpireChanges<HK>> expire(H key, Duration timeout, Collection<HK> hashKeys) {
        return this.expire(key, Expiration.from(timeout), ExpirationOptions.none(), hashKeys);
    }

    @Override
    public Mono<ExpireChanges<HK>> expire(H key, Expiration expiration, ExpirationOptions options, Collection<HK> hashKeys) {
        List orderedKeys = List.copyOf(hashKeys);
        ByteBuffer rawKey = this.rawKey(key);
        List<ByteBuffer> rawHashKeys = orderedKeys.stream().map(this::rawHashKey).toList();
        Mono raw = this.createFlux(connection -> connection.applyHashFieldExpiration((Publisher<ReactiveHashCommands.HashExpireCommand>)Mono.just((Object)ReactiveHashCommands.HashExpireCommand.expire(rawHashKeys, expiration).from(rawKey).withOptions(options))).map(ReactiveRedisConnection.CommandResponse::getOutput)).collectList();
        return raw.map(values -> ExpireChanges.of(orderedKeys, values));
    }

    @Override
    public @Nullable Mono<ExpireChanges<HK>> expireAt(H key, Instant expireAt, Collection<HK> hashKeys) {
        List orderedKeys = List.copyOf(hashKeys);
        ByteBuffer rawKey = this.rawKey(key);
        List<ByteBuffer> rawHashKeys = orderedKeys.stream().map(this::rawHashKey).toList();
        Mono raw = this.createFlux(connection -> connection.hExpireAt(rawKey, expireAt, rawHashKeys)).collectList();
        return raw.map(values -> ExpireChanges.of(orderedKeys, values));
    }

    @Override
    public @Nullable Mono<ExpireChanges<HK>> persist(H key, Collection<HK> hashKeys) {
        List orderedKeys = List.copyOf(hashKeys);
        ByteBuffer rawKey = this.rawKey(key);
        List<ByteBuffer> rawHashKeys = orderedKeys.stream().map(this::rawHashKey).toList();
        Mono raw = this.createFlux(connection -> connection.hPersist(rawKey, rawHashKeys)).collectList();
        return raw.map(values -> ExpireChanges.of(orderedKeys, values));
    }

    @Override
    public @Nullable Mono<Expirations<HK>> getTimeToLive(H key, TimeUnit timeUnit, Collection<HK> hashKeys) {
        if (timeUnit.compareTo(TimeUnit.MILLISECONDS) < 0) {
            throw new IllegalArgumentException("%s precision is not supported must be >= MILLISECONDS".formatted(new Object[]{timeUnit}));
        }
        List orderedKeys = List.copyOf(hashKeys);
        ByteBuffer rawKey = this.rawKey(key);
        List<ByteBuffer> rawHashKeys = orderedKeys.stream().map(this::rawHashKey).toList();
        Mono raw = this.createFlux(connection -> {
            if (TimeUnit.MILLISECONDS.equals((Object)timeUnit)) {
                return connection.hpTtl(rawKey, rawHashKeys);
            }
            return connection.hTtl(rawKey, rawHashKeys);
        }).collectList();
        return raw.map(values -> {
            Expirations.Timeouts timeouts = new Expirations.Timeouts(TimeUnit.MILLISECONDS.equals((Object)timeUnit) ? timeUnit : TimeUnit.SECONDS, (List<Long>)values);
            return Expirations.of(timeUnit, orderedKeys, timeouts);
        });
    }

    @Override
    public Mono<Boolean> delete(H key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveHashCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.hashCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveHashCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateFlux(connection -> (Publisher)function.apply(connection.hashCommands()));
    }

    private ByteBuffer rawKey(H key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawHashKey(HK key) {
        return this.serializationContext.getHashKeySerializationPair().write(key);
    }

    private ByteBuffer rawHashValue(HV key) {
        return this.serializationContext.getHashValueSerializationPair().write(key);
    }

    private @Nullable HK readHashKey(ByteBuffer value) {
        return this.serializationContext.getHashKeySerializationPair().read(value);
    }

    private HK readRequiredHashKey(ByteBuffer buffer) {
        HK hashKey = this.readHashKey(buffer);
        if (hashKey != null) {
            return hashKey;
        }
        throw new InvalidDataAccessApiUsageException("Deserialized hash key is null");
    }

    private @Nullable HV readHashValue(@Nullable ByteBuffer value) {
        return value != null ? (HV)this.serializationContext.getHashValueSerializationPair().read(value) : null;
    }

    private HV readRequiredHashValue(ByteBuffer buffer) {
        HV hashValue = this.readHashValue(buffer);
        if (hashValue != null) {
            return hashValue;
        }
        throw new InvalidDataAccessApiUsageException("Deserialized hash value is null");
    }

    private Map.Entry<HK, HV> deserializeHashEntry(Map.Entry<ByteBuffer, ByteBuffer> source) {
        return Converters.entryOf(this.readHashKey(source.getKey()), this.readHashValue(source.getValue()));
    }

    private List<HV> deserializeHashValues(List<ByteBuffer> source) {
        ArrayList<HV> values = new ArrayList<HV>(source.size());
        for (ByteBuffer byteBuffer : source) {
            values.add(this.readHashValue(byteBuffer));
        }
        return values;
    }
}

