/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.core.BoundHashFieldExpirationOperations;
import org.springframework.data.redis.core.ExpireChanges;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.Expirations;
import org.springframework.util.Assert;

class DefaultBoundHashFieldExpirationOperations<H, HK>
implements BoundHashFieldExpirationOperations<HK> {
    private final HashOperations<H, HK, ?> operations;
    private final H key;
    private final Supplier<? extends Collection<HK>> hashFields;

    public DefaultBoundHashFieldExpirationOperations(HashOperations<H, HK, ?> operations, H key, Supplier<? extends Collection<HK>> hashFields) {
        this.operations = operations;
        this.key = key;
        this.hashFields = hashFields;
    }

    @Override
    public ExpireChanges<HK> expire(Expiration expiration, ExpirationOptions options) {
        return this.operations.expire(this.key, expiration, options, this.getHashKeys());
    }

    @Override
    public @Nullable ExpireChanges<HK> expire(Duration timeout) {
        return this.operations.expire(this.key, timeout, this.getHashKeys());
    }

    @Override
    public @Nullable ExpireChanges<HK> expireAt(Instant expireAt) {
        return this.operations.expireAt(this.key, expireAt, this.getHashKeys());
    }

    @Override
    public @Nullable ExpireChanges<HK> persist() {
        return this.operations.persist(this.key, this.getHashKeys());
    }

    @Override
    public @Nullable Expirations<HK> getTimeToLive() {
        return this.operations.getTimeToLive(this.key, this.getHashKeys());
    }

    @Override
    public @Nullable Expirations<HK> getTimeToLive(TimeUnit timeUnit) {
        return this.operations.getTimeToLive(this.key, timeUnit, this.getHashKeys());
    }

    private Collection<HK> getHashKeys() {
        Collection<HK> hks = this.hashFields.get();
        Assert.state((hks != null ? 1 : 0) != 0, (String)"Hash keys must not be null");
        return hks;
    }
}

