/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.core.BoundHashFieldExpirationOperations;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultBoundHashFieldExpirationOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;

@NullUnmarked
public interface BoundHashOperations<H, HK, HV>
extends BoundKeyOperations<H> {
    public Long delete(Object ... var1);

    public Boolean hasKey(@NonNull Object var1);

    public HV get(@NonNull Object var1);

    public List<HV> multiGet(@NonNull Collection<@NonNull HK> var1);

    public Long increment(@NonNull HK var1, long var2);

    public Double increment(@NonNull HK var1, double var2);

    public HK randomKey();

    public Map.Entry<@NonNull HK, HV> randomEntry();

    public List<@NonNull HK> randomKeys(long var1);

    public Map<@NonNull HK, HV> randomEntries(long var1);

    public Set<@NonNull HK> keys();

    public Long lengthOfValue(@NonNull HK var1);

    public Long size();

    public void putAll(Map<? extends @NonNull HK, ? extends HV> var1);

    public void put(@NonNull HK var1, HV var2);

    public Boolean putIfAbsent(@NonNull HK var1, HV var2);

    public List<HV> values();

    public Map<@NonNull HK, HV> entries();

    public Cursor<Map.Entry<@NonNull HK, HV>> scan(@NonNull ScanOptions var1);

    default public @NonNull BoundHashFieldExpirationOperations<HK> hashExpiration() {
        return new DefaultBoundHashFieldExpirationOperations(this.getOperations().opsForHash(), this.getKey(), this::keys);
    }

    default public @NonNull BoundHashFieldExpirationOperations<HK> hashExpiration(HK ... hashFields) {
        return this.hashExpiration((Collection<HK>)Arrays.asList(hashFields));
    }

    default public @NonNull BoundHashFieldExpirationOperations<HK> hashExpiration(@NonNull Collection<@NonNull HK> hashFields) {
        return new DefaultBoundHashFieldExpirationOperations(this.getOperations().opsForHash(), this.getKey(), () -> hashFields);
    }

    @Override
    public @NonNull RedisOperations<H, ?> getOperations();

    public List<HV> getAndDelete(@NonNull Collection<@NonNull HK> var1);

    public List<HV> getAndExpire(Expiration var1, @NonNull Collection<@NonNull HK> var2);

    public void putAndExpire(Map<? extends @NonNull HK, ? extends HV> var1, RedisHashCommands.HashFieldSetOption var2, Expiration var3);
}

