/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.CopyArgs;
import io.lettuce.core.ExpireArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanStream;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.protocol.CommandArgs;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveKeyCommands
implements ReactiveKeyCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveKeyCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.CopyCommand>> copy(Publisher<ReactiveKeyCommands.CopyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            CopyArgs copyArgs = CopyArgs.Builder.replace((boolean)command.isReplace());
            if (command.getDatabase() != null) {
                copyArgs.destinationDb((long)command.getDatabase().intValue());
            }
            return cmd.copy((Object)command.getKey(), (Object)command.getTarget(), copyArgs).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.CopyCommand>((ReactiveKeyCommands.CopyCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return cmd.exists((Object[])new ByteBuffer[]{command.getKey()}).map(arg_0 -> LettuceConverters.longToBooleanConverter().convert(arg_0)).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return cmd.type((Object)command.getKey()).map(Converters::toDataType).map(respValue -> new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>((ReactiveRedisConnection.KeyCommand)command, (DataType)((Object)((Object)((Object)respValue)))));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<Collection<ByteBuffer>, Long>> touch(Publisher<Collection<ByteBuffer>> keysCollection) {
        return this.connection.execute(cmd -> Flux.from((Publisher)keysCollection).concatMap(keys -> {
            Assert.notEmpty((Collection)keys, (String)"Keys must not be null");
            return cmd.touch((Object[])keys.toArray(new ByteBuffer[keys.size()])).map(value -> new ReactiveRedisConnection.NumericResponse<Collection, Long>((Collection)keys, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> patterns) {
        return this.connection.execute(cmd -> Flux.from((Publisher)patterns).concatMap(pattern -> {
            Assert.notNull((Object)pattern, (String)"Pattern must not be null");
            return cmd.keys(pattern).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ByteBuffer)pattern, value));
        }));
    }

    @Override
    public Flux<ByteBuffer> scan(ScanOptions options) {
        Assert.notNull((Object)options, (String)"ScanOptions must not be null");
        return this.connection.execute(cmd -> ScanStream.scan((RedisKeyReactiveCommands)cmd, (ScanArgs)LettuceConverters.toScanArgs(options)));
    }

    @Override
    public Mono<ByteBuffer> randomKey() {
        return this.connection.execute(RedisKeyReactiveCommands::randomkey).next();
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getNewKey(), (String)"New name must not be null");
            return cmd.rename((Object)command.getKey(), (Object)command.getNewKey()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getNewKey(), (String)"New name must not be null");
            return cmd.renamenx((Object)command.getKey(), (Object)command.getNewKey()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return cmd.del((Object[])new ByteBuffer[]{command.getKey()}).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> keysCollection) {
        return this.connection.execute(cmd -> Flux.from((Publisher)keysCollection).concatMap(keys -> {
            Assert.notEmpty((Collection)keys, (String)"Keys must not be null");
            return cmd.del((Object[])keys.toArray(new ByteBuffer[keys.size()])).map(value -> new ReactiveRedisConnection.NumericResponse<List, Long>((List)keys, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> unlink(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return cmd.unlink((Object[])new ByteBuffer[]{command.getKey()}).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mUnlink(Publisher<List<ByteBuffer>> keysCollection) {
        return this.connection.execute(cmd -> Flux.from((Publisher)keysCollection).concatMap(keys -> {
            Assert.notEmpty((Collection)keys, (String)"Keys must not be null");
            return cmd.unlink((Object[])keys.toArray(new ByteBuffer[keys.size()])).map(value -> new ReactiveRedisConnection.NumericResponse<List, Long>((List)keys, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>> applyExpiration(Publisher<ReactiveKeyCommands.ExpireCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            if (command.getExpiration().isPersistent()) {
                return cmd.persist((Object)command.getKey()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)value));
            }
            ExpireArgs args = new ExpireArgs(this, (ReactiveKeyCommands.ExpireCommand)command){
                final /* synthetic */ ReactiveKeyCommands.ExpireCommand val$command;
                final /* synthetic */ LettuceReactiveKeyCommands this$0;
                {
                    this.val$command = expireCommand;
                    this.this$0 = this$0;
                }

                public <K, V> void build(CommandArgs<K, V> args) {
                    super.build(args);
                    if (ObjectUtils.nullSafeEquals((Object)this.val$command.getOptions(), (Object)ExpirationOptions.none())) {
                        return;
                    }
                    args.add(this.val$command.getOptions().getCondition().name());
                }
            };
            if (command.getExpiration().isUnixTimestamp()) {
                if (command.getExpiration().getTimeUnit().equals((Object)TimeUnit.MILLISECONDS)) {
                    return cmd.pexpireat((Object)command.getKey(), command.getExpiration().getExpirationTimeInMilliseconds(), args).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)value));
                }
                return cmd.expireat((Object)command.getKey(), command.getExpiration().getExpirationTimeInSeconds(), args).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)value));
            }
            if (command.getExpiration().getTimeUnit().equals((Object)TimeUnit.MILLISECONDS)) {
                return cmd.pexpire((Object)command.getKey(), command.getExpiration().getExpirationTimeInMilliseconds(), args).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)value));
            }
            return cmd.expire((Object)command.getKey(), command.getExpiration().getExpirationTimeInSeconds(), args).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireCommand>((ReactiveKeyCommands.ExpireCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> expireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getExpireAt(), (String)"Expire at must not be null");
            return cmd.expireat((Object)command.getKey(), command.getExpireAt().getEpochSecond(), LettuceReactiveKeyCommands.getExpireArgs(command.getOptions())).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>((ReactiveKeyCommands.ExpireAtCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>> pExpireAt(Publisher<ReactiveKeyCommands.ExpireAtCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getExpireAt(), (String)"Expire at must not be null");
            return cmd.pexpireat((Object)command.getKey(), command.getExpireAt().toEpochMilli(), LettuceReactiveKeyCommands.getExpireArgs(command.getOptions())).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.ExpireAtCommand>((ReactiveKeyCommands.ExpireAtCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> persist(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return cmd.persist((Object)command.getKey()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> ttl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return cmd.ttl((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> pTtl(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return cmd.pttl((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>> move(Publisher<ReactiveKeyCommands.MoveCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getDatabase(), (String)"Database must not be null");
            return cmd.move((Object)command.getKey(), command.getDatabase().intValue()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>((ReactiveKeyCommands.MoveCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Mono<ValueEncoding> encodingOf(ByteBuffer key) {
        return this.connection.execute(cmd -> cmd.objectEncoding((Object)key).map(ValueEncoding::of).defaultIfEmpty((Object)ValueEncoding.RedisValueEncoding.VACANT)).next();
    }

    @Override
    public Mono<Duration> idletime(ByteBuffer key) {
        return this.connection.execute(cmd -> cmd.objectIdletime((Object)key).map(Duration::ofSeconds)).next();
    }

    @Override
    public Mono<Long> refcount(ByteBuffer key) {
        return this.connection.execute(cmd -> cmd.objectRefcount((Object)key)).next();
    }

    @Override
    public Mono<Long> exists(List<ByteBuffer> keys) {
        Assert.notNull(keys, (String)"Key list must not be null");
        Assert.notEmpty(keys, (String)"Key list must not be empty");
        return this.connection.execute(cmd -> cmd.exists((Object[])((ByteBuffer[])keys.toArray(ByteBuffer[]::new)))).next();
    }

    private static ExpireArgs getExpireArgs(final ExpirationOptions options) {
        return new ExpireArgs(){

            public <K, V> void build(CommandArgs<K, V> args) {
                super.build(args);
                if (ObjectUtils.nullSafeEquals((Object)((Object)options.getCondition()), (Object)((Object)ExpirationOptions.Condition.ALWAYS))) {
                    return;
                }
                args.add(options.getCondition().name());
            }
        };
    }
}

