/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ExpireArgs;
import io.lettuce.core.KeyValue;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.async.RedisHashAsyncCommands;
import io.lettuce.core.protocol.CommandArgs;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@NullUnmarked
class LettuceHashCommands
implements RedisHashCommands {
    private final LettuceConnection connection;

    LettuceHashCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean hSet(byte @NonNull [] key, byte @NonNull [] field, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().just(RedisHashAsyncCommands::hset, key, field, value);
    }

    @Override
    public Boolean hSetNX(byte @NonNull [] key, byte @NonNull [] field, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().just(RedisHashAsyncCommands::hsetnx, key, field, value);
    }

    @Override
    public Long hDel(byte @NonNull [] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hdel, key, fields);
    }

    @Override
    public Boolean hExists(byte @NonNull [] key, byte @NonNull [] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Fields must not be null");
        return (Boolean)this.connection.invoke().just(RedisHashAsyncCommands::hexists, key, field);
    }

    @Override
    public byte[] hGet(byte @NonNull [] key, byte @NonNull [] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (byte[])this.connection.invoke().just(RedisHashAsyncCommands::hget, key, field);
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Map)this.connection.invoke().just(RedisHashAsyncCommands::hgetall, key);
    }

    @Override
    public byte @Nullable [] hRandField(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisHashAsyncCommands::hrandfield, key);
    }

    @Override
    public @Nullable Map.Entry<byte[], byte[]> hRandFieldWithValues(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Map.Entry)this.connection.invoke().from(RedisHashAsyncCommands::hrandfieldWithvalues, key).get(LettuceHashCommands::toEntry);
    }

    @Override
    public @Nullable List<byte[]> hRandField(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisHashAsyncCommands::hrandfield, key, count);
    }

    @Override
    public @Nullable List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hrandfieldWithvalues, key, count).toList(LettuceHashCommands::toEntry);
    }

    @Override
    public Long hIncrBy(byte @NonNull [] key, byte @NonNull [] field, long delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hincrby, key, field, delta);
    }

    @Override
    public Double hIncrBy(byte @NonNull [] key, byte @NonNull [] field, double delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (Double)this.connection.invoke().just(RedisHashAsyncCommands::hincrbyfloat, key, field, delta);
    }

    @Override
    public Set<byte[]> hKeys(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hkeys, key).toSet();
    }

    @Override
    public Long hLen(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hlen, key);
    }

    @Override
    public List<byte[]> hMGet(byte @NonNull [] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hmget, key, fields).toList(source -> (byte[])source.getValueOrElse(null));
    }

    @Override
    public void hMSet(byte @NonNull [] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(hashes, (String)"Hashes must not be null");
        this.connection.invokeStatus().just(RedisHashAsyncCommands::hmset, key, hashes);
    }

    @Override
    public List<byte[]> hVals(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().just(RedisHashAsyncCommands::hvals, key);
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte @NonNull [] key, @NonNull ScanOptions options) {
        return this.hScan(key, Cursor.CursorId.initial(), options);
    }

    @Override
    public List<Long> hExpire(byte @NonNull [] key, long seconds, @NonNull ExpirationOptions.Condition condition, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hexpire, key, seconds, LettuceHashCommands.getExpireArgs(condition), fields).toList();
    }

    @Override
    public List<Long> hpExpire(byte @NonNull [] key, long millis, @NonNull ExpirationOptions.Condition condition, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hpexpire, key, millis, LettuceHashCommands.getExpireArgs(condition), fields).toList();
    }

    @Override
    public List<Long> hExpireAt(byte @NonNull [] key, long unixTime, @NonNull ExpirationOptions.Condition condition, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hexpireat, key, unixTime, LettuceHashCommands.getExpireArgs(condition), fields).toList();
    }

    @Override
    public List<Long> hpExpireAt(byte @NonNull [] key, long unixTimeInMillis, @NonNull ExpirationOptions.Condition condition, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hpexpireat, key, unixTimeInMillis, LettuceHashCommands.getExpireArgs(condition), fields).toList();
    }

    @Override
    public List<Long> hPersist(byte @NonNull [] key, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hpersist, key, fields).toList();
    }

    @Override
    public List<Long> hTtl(byte @NonNull [] key, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::httl, key, fields).toList();
    }

    @Override
    public List<Long> hTtl(byte @NonNull [] key, @NonNull TimeUnit timeUnit, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::httl, key, fields).toList(Converters.secondsToTimeUnit(timeUnit));
    }

    @Override
    public List<Long> hpTtl(byte @NonNull [] key, byte[] ... fields) {
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hpttl, key, fields).toList();
    }

    @Override
    public List<byte[]> hGetDel(byte @NonNull [] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hgetdel, key, fields).toList(source -> (byte[])source.getValueOrElse(null));
    }

    @Override
    public List<byte[]> hGetEx(byte @NonNull [] key, Expiration expiration, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().fromMany(RedisHashAsyncCommands::hgetex, key, LettuceConverters.toHGetExArgs(expiration), fields).toList(source -> (byte[])source.getValueOrElse(null));
    }

    @Override
    public Boolean hSetEx(byte @NonNull [] key, @NonNull Map<byte[], byte[]> hashes, RedisHashCommands.HashFieldSetOption condition, Expiration expiration) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(hashes, (String)"Hashes must not be null");
        return this.connection.invoke().from(RedisHashAsyncCommands::hsetex, key, LettuceConverters.toHSetExArgs(condition, expiration), hashes).get(LettuceConverters.longToBooleanConverter());
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte @NonNull [] key, @NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, cursorId, options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte @NonNull [] key, @NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
                if (LettuceHashCommands.this.connection.isQueueing() || LettuceHashCommands.this.connection.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'HSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanCursor scanCursor = LettuceHashCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                MapScanCursor mapScanCursor = (MapScanCursor)LettuceHashCommands.this.connection.invoke().just(RedisHashAsyncCommands::hscan, key, scanCursor, scanArgs);
                String nextCursorId = mapScanCursor.getCursor();
                Map values = mapScanCursor.getMap();
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Cursor.CursorId.of(nextCursorId), values.entrySet());
            }

            @Override
            protected void doClose() {
                LettuceHashCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public @Nullable Long hStrLen(byte @NonNull [] key, byte @NonNull [] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return (Long)this.connection.invoke().just(RedisHashAsyncCommands::hstrlen, key, field);
    }

    private static @Nullable Map.Entry<byte[], byte[]> toEntry(KeyValue<byte[], byte[]> value) {
        return value.hasValue() ? Converters.entryOf((byte[])value.getKey(), (byte[])value.getValue()) : null;
    }

    private static ExpireArgs getExpireArgs(final ExpirationOptions.Condition condition) {
        return new ExpireArgs(){

            public <K, V> void build(CommandArgs<K, V> args) {
                if (ObjectUtils.nullSafeEquals((Object)((Object)condition), (Object)((Object)ExpirationOptions.Condition.ALWAYS))) {
                    return;
                }
                args.add(condition.name());
            }
        };
    }
}

