/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.Assert;

@NullUnmarked
public interface ValueOperations<K, V> {
    public void set(@NonNull K var1, @NonNull V var2);

    public V setGet(@NonNull K var1, @NonNull V var2, long var3, @NonNull TimeUnit var5);

    public V setGet(@NonNull K var1, @NonNull V var2, @NonNull Duration var3);

    public void set(@NonNull K var1, @NonNull V var2, long var3, @NonNull TimeUnit var5);

    default public void set(@NonNull K key, @NonNull V value, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        if (TimeoutUtils.hasMillis(timeout)) {
            this.set(key, value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.set(key, value, timeout.getSeconds(), TimeUnit.SECONDS);
        }
    }

    public Boolean setIfAbsent(@NonNull K var1, @NonNull V var2);

    public Boolean setIfAbsent(@NonNull K var1, @NonNull V var2, long var3, @NonNull TimeUnit var5);

    default public Boolean setIfAbsent(@NonNull K key, @NonNull V value, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfAbsent(key, value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfAbsent(key, value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    public Boolean setIfPresent(@NonNull K var1, @NonNull V var2);

    public Boolean setIfPresent(@NonNull K var1, @NonNull V var2, long var3, @NonNull TimeUnit var5);

    default public Boolean setIfPresent(@NonNull K key, @NonNull V value, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfPresent(key, value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfPresent(key, value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    public void multiSet(Map<? extends @NonNull K, ? extends @NonNull V> var1);

    public Boolean multiSetIfAbsent(Map<? extends @NonNull K, ? extends @NonNull V> var1);

    public V get(Object var1);

    public V getAndDelete(@NonNull K var1);

    public V getAndExpire(@NonNull K var1, long var2, @NonNull TimeUnit var4);

    public V getAndExpire(@NonNull K var1, @NonNull Duration var2);

    public V getAndPersist(@NonNull K var1);

    public V getAndSet(@NonNull K var1, @NonNull V var2);

    public List<V> multiGet(@NonNull Collection<@NonNull K> var1);

    public Long increment(@NonNull K var1);

    public Long increment(@NonNull K var1, long var2);

    public Double increment(@NonNull K var1, double var2);

    public Long decrement(@NonNull K var1);

    public Long decrement(@NonNull K var1, long var2);

    public Integer append(@NonNull K var1, @NonNull String var2);

    public String get(@NonNull K var1, long var2, long var4);

    public void set(@NonNull K var1, @NonNull V var2, long var3);

    public Long size(@NonNull K var1);

    public Boolean setBit(@NonNull K var1, long var2, boolean var4);

    public Boolean getBit(@NonNull K var1, long var2);

    public List<Long> bitField(@NonNull K var1, @NonNull BitFieldSubCommands var2);

    public @NonNull RedisOperations<K, V> getOperations();
}

